/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.sbet.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.sbet.SBET;
import dev.worldgen.sbet.config.ConfigCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private static Path FILE_PATH;
    private static final ConfigCodec DEFAULT_CONFIG;
    private static ConfigCodec CONFIG;

    public static void load() {
        FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("subjectively-better-enchantment-tooltips.json");
        if (!Files.isRegularFile(FILE_PATH, new LinkOption[0])) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            SBET.LOGGER.info("Config file for Subjectively Better Enchantment Tooltips not found, creating file with default values...");
            try (BufferedWriter writer = Files.newBufferedWriter(FILE_PATH, new OpenOption[0]);){
                writer.write(gson.toJson((JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT_CONFIG).result().get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(FILE_PATH);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            Optional<ConfigCodec> result = ConfigCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
            if (result.isEmpty()) {
                result = Optional.of(DEFAULT_CONFIG);
            }
            CONFIG = (ConfigCodec)result.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(FILE_PATH, new OpenOption[0]);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)CONFIG).result().get()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigCodec getConfig() {
        return CONFIG;
    }

    static {
        DEFAULT_CONFIG = new ConfigCodec(new ConfigCodec.TooltipColors(0x55FF55, 0xFF55FF, 0xFF5555), true, ConfigCodec.DEFAULT_DESCRIPTIONS);
    }
}

