/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.whiterhinoceros.mob;

import aquariusplayz.animalgarden.whiterhinoceros.mob.ModAnimationState;
import aquariusplayz.animalgarden.whiterhinoceros.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.whiterhinoceros.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModAttackMobGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModBreedGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModChargeMeleeAttackGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModEatBlockGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModFollowMotherParentGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModHurtByTargetGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModOwnerHurtByTargetGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModOwnerHurtTargetGoal;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModPanicGoal;
import aquariusplayz.animalgarden.whiterhinoceros.setup.Registrations;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> HORN_SIZE = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT_TYPE = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    private ModEatBlockGoal eatBlockGoal;
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState breathing = new ModAnimationState();
    public final ModAnimationState eyeLookUp = new ModAnimationState();
    public final ModAnimationState eyeLookDown = new ModAnimationState();
    public final ModAnimationState eyeLookBackwards = new ModAnimationState();
    public final ModAnimationState eyeLookForward = new ModAnimationState();
    public final ModAnimationState sitDown = new ModAnimationState();
    public final ModAnimationState sitting = new ModAnimationState();
    public final ModAnimationState headLookUp = new ModAnimationState();
    public final ModAnimationState headLookDown = new ModAnimationState();
    public final ModAnimationState headLookLeft = new ModAnimationState();
    public final ModAnimationState headLookRight = new ModAnimationState();
    public final ModAnimationState headLookMoreUp = new ModAnimationState();
    public final ModAnimationState headLookMoreDown = new ModAnimationState();
    public final ModAnimationState headLookMoreLeft = new ModAnimationState();
    public final ModAnimationState headLookMoreRight = new ModAnimationState();
    public final ModAnimationState headTiltLeft = new ModAnimationState();
    public final ModAnimationState headTiltRight = new ModAnimationState();
    public final ModAnimationState headTiltMoreLeft = new ModAnimationState();
    public final ModAnimationState headTiltMoreRight = new ModAnimationState();
    public final ModAnimationState eat = new ModAnimationState();
    public final ModAnimationState rightEar = new ModAnimationState();
    public final ModAnimationState rightEar2 = new ModAnimationState();
    public final ModAnimationState leftEar = new ModAnimationState();
    public final ModAnimationState leftEar2 = new ModAnimationState();
    public final ModAnimationState sniffing = new ModAnimationState();
    public final ModAnimationState pierceAttack1 = new ModAnimationState();
    public final ModAnimationState pierceAttack2 = new ModAnimationState();
    public final ModAnimationState pierceAttack3 = new ModAnimationState();
    public boolean isRunning = false;
    public int chargeAttackCooldown;

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new ModEatBlockGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ModChargeMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new ModPanicGoal(this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new ModBreedGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, p_332367_ -> this.isFood((ItemStack)p_332367_), false));
        this.goalSelector.addGoal(4, (Goal)new ModFollowMotherParentGoal(this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)this.eatBlockGoal);
        this.targetSelector.addGoal(1, (Goal)new ModHurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ModOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new ModOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new ModAttackMobGoal(this, LivingEntity.class, 20, true, false, this::protectBaby));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, this::canBeATarget));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean protectBaby(LivingEntity p_21675_) {
        Player player;
        if (p_21675_ instanceof ModMob) {
            return false;
        }
        if (p_21675_ instanceof Player && (player = (Player)p_21675_) == this.getOwner()) {
            return false;
        }
        return this.wantsToAttack(p_21675_, this.getOwner());
    }

    public boolean canBeATarget(LivingEntity p_21675_) {
        if (p_21675_ instanceof ModMob) {
            return false;
        }
        if (!this.wantsToAttack(p_21675_, this.getOwner())) {
            return false;
        }
        return this.isAngryAt(p_21675_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, (double)0.275f).add(Attributes.ARMOR, 10.0).add(Attributes.ARMOR_TOUGHNESS, 8.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 5.25);
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_366700_, SpawnGroupData p_146749_) {
        this.setGender(this.getRandom().nextInt(2));
        this.setStats();
        this.setHornSize(this.getRandom().nextInt(5));
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    private void setStats() {
        if (this.getAge() < 0) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
        } else if (this.getGender() == 1) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(75.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.75);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(100.0);
            this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
        }
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.chargeAttackCooldown > 0) {
            --this.chargeAttackCooldown;
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            if (this.getRandom().nextInt(1500) == 0 && this.getHornSize() < 9 && (this.age >= 0 || this.getHornSize() <= 4)) {
                this.setHornSize(this.getHornSize() + 1);
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
                this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
            }
            if (this.getTarget() == null && this.isRunning) {
                this.isRunning = false;
                this.level().broadcastEntityEvent((Entity)this, (byte)12);
            }
        }
        if (this.level().isClientSide()) {
            int i;
            if (!this.breathing.isStarted()) {
                this.breathing.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.wink, 0.75f)) {
                this.wink.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 1.0f)) {
                this.sniffing.start(this.tickCount);
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.leftEar, 3.0f) && this.animationEnded(this.leftEar2, 3.0f)) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.leftEar.start(this.tickCount);
                } else {
                    this.leftEar2.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.rightEar, 3.0f) && this.animationEnded(this.rightEar2, 3.0f)) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.rightEar.start(this.tickCount);
                } else {
                    this.rightEar2.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.eyeLookUp, 2.25f) && this.animationEnded(this.eyeLookDown, 2.25f)) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.eyeLookUp.start(this.tickCount);
                } else {
                    this.eyeLookDown.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.eyeLookBackwards, 2.0f) && this.animationEnded(this.eyeLookForward, 2.0f)) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.eyeLookBackwards.start(this.tickCount);
                } else {
                    this.eyeLookForward.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.eat, 3.0f) && this.animationEnded(this.headLookUp, 3.0f) && this.animationEnded(this.headLookDown, 3.0f) && this.animationEnded(this.headLookMoreUp, 3.5f) && this.animationEnded(this.headLookMoreDown, 3.5f)) {
                i = this.getRandom().nextInt(4);
                if (i == 0) {
                    this.headLookUp.start(this.tickCount);
                } else if (i == 1) {
                    this.headLookDown.start(this.tickCount);
                } else if (i == 2) {
                    this.headLookMoreUp.start(this.tickCount);
                } else {
                    this.headLookMoreDown.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.headLookLeft, 3.0f) && this.animationEnded(this.headLookRight, 3.0f) && this.animationEnded(this.headLookMoreLeft, 3.5f) && this.animationEnded(this.headLookMoreRight, 3.5f)) {
                i = this.getRandom().nextInt(4);
                if (i == 0) {
                    this.headLookLeft.start(this.tickCount);
                } else if (i == 1) {
                    this.headLookRight.start(this.tickCount);
                } else if (i == 2) {
                    this.headLookMoreLeft.start(this.tickCount);
                } else {
                    this.headLookMoreRight.start(this.tickCount);
                }
            }
            if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.eat, 3.0f) && this.animationEnded(this.headTiltLeft, 2.5f) && this.animationEnded(this.headTiltRight, 2.5f) && this.animationEnded(this.headTiltMoreLeft, 3.0f) && this.animationEnded(this.headTiltMoreRight, 3.0f)) {
                i = this.getRandom().nextInt(4);
                if (i == 0) {
                    this.headTiltLeft.start(this.tickCount);
                } else if (i == 1) {
                    this.headTiltRight.start(this.tickCount);
                } else if (i == 2) {
                    this.headTiltMoreLeft.start(this.tickCount);
                } else {
                    this.headTiltMoreRight.start(this.tickCount);
                }
            }
        }
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(this.isRunning ? 3 : 5) == 0;
    }

    public void handleEntityEvent(byte p_397414_) {
        if (p_397414_ == 4) {
            if (this.animationEnded(this.pierceAttack1, 2.0f) && this.animationEnded(this.pierceAttack2, 2.0f) && this.animationEnded(this.pierceAttack3, 2.0f)) {
                int i = this.getRandom().nextInt(3);
                if (i == 0) {
                    this.pierceAttack1.start(this.tickCount);
                } else if (i == 1) {
                    this.pierceAttack2.start(this.tickCount);
                } else {
                    this.pierceAttack3.start(this.tickCount);
                }
            }
        } else if (p_397414_ == 5) {
            if (this.animationEnded(this.eat, 3.0f)) {
                this.eat.start(this.tickCount);
            }
        } else if (p_397414_ == 9) {
            if (this.getHornSize() < 9) {
                this.setHornSize(this.getHornSize() + 1);
            }
        } else if (p_397414_ == 10) {
            if (this.animationEnded(this.eat, 3.0f)) {
                this.eat.start(this.tickCount);
            }
        } else if (p_397414_ == 11) {
            this.isRunning = true;
        } else if (p_397414_ == 12) {
            this.isRunning = false;
        } else {
            super.handleEntityEvent(p_397414_);
        }
    }

    public void ate() {
        super.ate();
        if (this.isBaby()) {
            this.ageUp(10);
        }
        if (this.getHealth() < this.getMaxHealth()) {
            this.heal(25.0f);
        }
    }

    public void setAge(int p_146763_) {
        super.setAge(p_146763_);
        this.setStats();
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand) {
            return false;
        }
        if (p_30389_ instanceof ModMob) {
            ModMob mob = (ModMob)p_30389_;
            return !mob.isTame() || mob.getOwner() != p_30390_;
        }
        if (p_30389_ instanceof Player) {
            Player player1;
            Player player = (Player)p_30389_;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
    }

    protected void applyTamingSideEffects() {
        super.applyTamingSideEffects();
        this.setStats();
    }

    public boolean doHurtTarget(Entity p_32257_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(p_32257_);
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (this.isTame()) {
            if (this.isFood(itemstack)) {
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(25.0f);
                }
                if (this.level() instanceof ServerLevel) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)5);
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public boolean isFood(ItemStack p_30440_) {
        return p_30440_.is(Registrations.FOOD_ITEMS);
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(10) == 0) {
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_);
        if (this.isTame()) {
            mob.setOwnerUUID(this.getOwnerUUID());
            mob.setTame(true, true);
            mob.setVariantType(this.getVariantType());
        }
        mob.setBaby(true);
        mob.setStats();
        mob.setHornSize(0);
        return mob;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        if (this.getAge() < 0) {
            return (SoundEvent)Registrations.BABY_IDLE.get();
        }
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        if (this.getAge() < 0) {
            return (SoundEvent)Registrations.BABY_IDLE.get();
        }
        return (SoundEvent)Registrations.HURT.get();
    }

    protected SoundEvent getDeathSound() {
        if (this.getAge() < 0) {
            return (SoundEvent)Registrations.BABY_IDLE.get();
        }
        return (SoundEvent)Registrations.HURT.get();
    }

    protected void playStepSound(BlockPos p_29419_, BlockState p_29420_) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 2.0f);
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isPushable() {
        return this.getAge() < 0;
    }

    public boolean hurt(DamageSource p_364880_, float p_366649_) {
        if (this.isInvulnerableTo(p_364880_)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurt(p_364880_, p_366649_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        p_335317_.define(VARIANT_TYPE, (Object)0);
        p_335317_.define(GENDER, (Object)0);
        p_335317_.define(HORN_SIZE, (Object)0);
    }

    public int getHornSize() {
        return (Integer)this.entityData.get(HORN_SIZE);
    }

    private void setHornSize(int p_30398_) {
        this.entityData.set(HORN_SIZE, (Object)p_30398_);
        float hornSize = this.getHornSize() > 0 ? (float)this.getHornSize() * 0.75f : 0.0f;
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(5.25 + (double)hornSize);
    }

    public int getVariantType() {
        return (Integer)this.entityData.get(VARIANT_TYPE);
    }

    private void setVariantType(int p_30398_) {
        this.entityData.set(VARIANT_TYPE, (Object)p_30398_);
    }

    public int getGender() {
        return (Integer)this.entityData.get(GENDER);
    }

    private void setGender(int p_30398_) {
        this.entityData.set(GENDER, (Object)p_30398_);
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("VariantType", this.getVariantType());
        p_29422_.putInt("Gender", this.getGender());
        p_29422_.putInt("HornSize", this.getHornSize());
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setVariantType(p_29402_.getInt("VariantType"));
        this.setGender(p_29402_.getInt("Gender"));
        this.setHornSize(p_29402_.getInt("HornSize"));
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }
}

