/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.whiterhinoceros.mob.goals;

import aquariusplayz.animalgarden.whiterhinoceros.mob.ModMob;
import aquariusplayz.animalgarden.whiterhinoceros.mob.goals.ModMeleeAttackGoal;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ModChargeMeleeAttackGoal
extends ModMeleeAttackGoal {
    public final ModMob mob;
    public int attackCooldown;

    public ModChargeMeleeAttackGoal(ModMob p_25552_, double p_25553_, boolean p_25554_) {
        super(p_25552_, p_25553_, p_25554_);
        this.mob = p_25552_;
    }

    @Override
    public boolean canUse() {
        if (this.mob.getAge() < 0) {
            return false;
        }
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (livingentity != null && livingentity.isUnderWater()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    public void tick() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        LivingEntity livingentity = this.mob.getTarget();
        if (this.mob.chargeAttackCooldown == 0 && livingentity != null) {
            if (!this.mob.isRunning) {
                this.mob.isRunning = true;
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)11);
            }
        } else if (this.mob.chargeAttackCooldown > 0 && livingentity != null && this.mob.isRunning) {
            this.mob.isRunning = false;
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)12);
        }
        this.speedModifier = this.mob.isRunning ? (double)1.3f : 1.0;
        super.tick();
        if (livingentity != null && this.mob.chargeAttackCooldown == 0) {
            for (LivingEntity mob : this.mob.level().getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate(2.0, 2.0, 2.0))) {
                if (mob instanceof ModMob || !this.mob.wantsToAttack(mob, this.mob.getOwner()) || this.attackCooldown != 0 || livingentity == mob) continue;
                this.mob.doHurtTarget((Entity)mob);
                double d0 = mob.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                double d1 = Math.max(0.0, 1.0 - d0);
                mob.setDeltaMovement(mob.getDeltaMovement().add(0.0, (double)0.6f * d1, 0.0));
                this.attackCooldown = 20;
            }
        }
    }

    @Override
    protected void checkAndPerformAttack(LivingEntity p_29589_) {
        if (this.canPerformAttack(p_29589_)) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)p_29589_);
            if (this.mob.chargeAttackCooldown == 0) {
                this.mob.chargeAttackCooldown = 300;
            }
            double d0 = p_29589_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            double d1 = Math.max(0.0, 1.0 - d0);
            p_29589_.setDeltaMovement(p_29589_.getDeltaMovement().add(0.0, (double)0.8f * d1, 0.0));
        }
    }
}

