/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.api.pipes.Pipe;
import com.thepigcat.buildcraft.api.pipes.PipeHolder;
import com.thepigcat.buildcraft.registries.BCPipes;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.jetbrains.annotations.NotNull;

public final class PipesRegistry {
    public static final Map<String, Pipe> PIPES = new HashMap<String, Pipe>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean isErrored = false;

    public static void writeDefaultPipeFiles() {
        File dir = PipesRegistry.getPipesDirectory();
        if (!dir.exists() && dir.mkdirs()) {
            Map<String, Pipe> pipes = BCPipes.HELPER.getPipes();
            for (Map.Entry<String, Pipe> entry : pipes.entrySet()) {
                File file = new File(dir, entry.getKey() + ".json");
                JsonElement json = entry.getValue().toJson();
                if (json == null) {
                    BuildcraftLegacy.LOGGER.error("Pipe {} could not be written to Json due to encoding error", (Object)entry.getKey());
                    continue;
                }
                try (FileWriter writer = new FileWriter(file);){
                    GSON.toJson(json, (Appendable)writer);
                }
                catch (Exception e) {
                    BuildcraftLegacy.LOGGER.error("An error occurred while generating pipe jsons, affected pipe: {}", (Object)entry.getKey(), (Object)e);
                }
            }
        }
    }

    public static void loadPipes() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = PipesRegistry.getPipesDirectory();
        PipesRegistry.writeDefaultPipeFiles();
        PIPES.clear();
        if (!dir.mkdirs() && dir.isDirectory()) {
            PipesRegistry.loadFiles(dir);
        }
        stopwatch.stop();
        BuildcraftLegacy.LOGGER.info("Loaded {} pipe type(s) in {} ms", (Object)PIPES.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFiles(File dir) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        ArrayList<PipeHolder> pipes = new ArrayList<PipeHolder>();
        for (File file : files) {
            InputStreamReader reader;
            PipeHolder pipe;
            block17: {
                JsonObject json;
                block16: {
                    pipe = null;
                    reader = null;
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                    json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    reader.close();
                    if (!PipesRegistry.handleMigrations(json)) break block16;
                    try (FileWriter writer = new FileWriter(file);){
                        GSON.toJson((JsonElement)json, (Appendable)writer);
                    }
                    catch (Exception e) {
                        BuildcraftLegacy.LOGGER.error("An error occurred while migrating pipe json {}", (Object)file.getName(), (Object)e);
                        IOUtils.closeQuietly((Reader)reader);
                        continue;
                    }
                }
                try {
                    Pipe loadedPipe = Pipe.fromJson((JsonElement)json);
                    if (loadedPipe == null) break block17;
                    String id = file.getName();
                    if (id.contains(".json")) {
                        id = id.substring(0, id.length() - 5);
                    }
                    pipe = new PipeHolder(id, loadedPipe);
                }
                catch (Exception e) {
                    try {
                        BuildcraftLegacy.LOGGER.error("An error occurred while reading pipe json {}", (Object)file.getName(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            IOUtils.closeQuietly((Reader)reader);
            if (pipe == null || pipe.value().disabled()) continue;
            pipes.add(pipe);
        }
        for (PipeHolder pipeHolder : pipes) {
            PipesRegistry.register(pipeHolder);
        }
    }

    private static boolean handleMigrations(JsonObject json) {
        boolean changed = false;
        return changed;
    }

    public static void register(PipeHolder pipe) {
        if (PIPES.containsKey(pipe.key())) {
            isErrored = true;
            throw new RuntimeException(String.format("Tried to register multiple pipes with the same name: %s", pipe.key()));
        }
        PIPES.put(pipe.key(), pipe.value());
    }

    @NotNull
    private static File getPipesDirectory() {
        return FMLPaths.CONFIGDIR.get().resolve("buildcraft/pipes").toFile();
    }
}

