/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.blockentities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.utils.IOAction;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.thepigcat.buildcraft.api.blockentities.RedstoneBlockEntity;
import com.thepigcat.buildcraft.api.blocks.EngineBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class EngineBlockEntity
extends ContainerBlockEntity
implements RedstoneBlockEntity {
    private RedstoneBlockEntity.RedstoneSignalType redstoneSignalType;
    private int redstoneSignalStrength;
    private BlockCapabilityCache<IEnergyStorage, Direction> exportCache;
    private CompoundTag movementData;
    protected boolean active;
    public float movement;
    public float lastMovement;
    private boolean backward;
    private Map<Direction, it.unimi.dsi.fastutil.Pair<IOAction, int[]>> sidedInteractions;

    public EngineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.addEnergyStorage(HandlerUtils::newEnergystorage, builder -> builder.capacity(this.getEnergyCapacity()).maxTransfer(this.getEnergyProduction()));
        this.movement = 0.5f;
        this.sidedInteractions = new HashMap<Direction, it.unimi.dsi.fastutil.Pair<IOAction, int[]>>();
        Direction facing = (Direction)this.getBlockState().getValue((Property)EngineBlock.FACING);
        for (Direction dir : Direction.values()) {
            if (dir == facing) continue;
            this.sidedInteractions.put(dir, (it.unimi.dsi.fastutil.Pair<IOAction, int[]>)it.unimi.dsi.fastutil.Pair.of((Object)IOAction.INSERT, (Object)new int[]{0}));
        }
        this.redstoneSignalType = RedstoneBlockEntity.RedstoneSignalType.IGNORED;
    }

    public abstract int getEnergyCapacity();

    public abstract int getEnergyProduction();

    public void onLoad() {
        super.onLoad();
        if (this.movementData != null) {
            this.backward = this.movementData.getBoolean("backward");
            this.movement = this.movementData.getFloat("movement");
            this.lastMovement = this.movementData.getFloat("lastMovement");
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)EngineBlock.FACING);
        this.initCaches(facing);
    }

    public void initCaches(Direction facing) {
        Direction[] directionArray = this.level;
        if (directionArray instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            this.sidedInteractions = new HashMap<Direction, it.unimi.dsi.fastutil.Pair<IOAction, int[]>>();
            for (Direction dir : Direction.values()) {
                if (dir == facing) continue;
                this.sidedInteractions.put(dir, (it.unimi.dsi.fastutil.Pair<IOAction, int[]>)it.unimi.dsi.fastutil.Pair.of((Object)IOAction.INSERT, (Object)new int[]{0}));
            }
            this.exportCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.worldPosition.relative(facing), (Object)facing.getOpposite());
        }
    }

    public void tick() {
        super.tick();
        this.lastMovement = this.movement;
        if (this.isActive()) {
            if (!this.backward) {
                this.movement -= 0.01f;
                if (this.movement < 0.0f) {
                    this.backward = true;
                }
            } else {
                this.movement += 0.01f;
                if (this.movement >= 0.5f) {
                    this.backward = false;
                }
            }
        }
        if (!this.level.isClientSide()) {
            int extractedEnergy = this.getEnergyStorage().extractEnergy(5, false);
            IEnergyStorage energyStorage = (IEnergyStorage)this.exportCache.getCapability();
            if (energyStorage != null) {
                int received = energyStorage.receiveEnergy(extractedEnergy, false);
                this.getEnergyStorage().receiveEnergy(extractedEnergy - received, false);
            }
        }
    }

    @Override
    public void setRedstoneSignalType(RedstoneBlockEntity.RedstoneSignalType redstoneSignalType) {
        this.redstoneSignalType = redstoneSignalType;
    }

    @Override
    public RedstoneBlockEntity.RedstoneSignalType getRedstoneSignalType() {
        return this.redstoneSignalType;
    }

    public void setRedstoneSignalStrength(int redstoneSignalStrength) {
        this.redstoneSignalStrength = redstoneSignalStrength;
    }

    public int getRedstoneSignalStrength() {
        return this.redstoneSignalStrength;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        this.movementData = tag.getCompound("movementData");
        this.active = tag.getBoolean("active");
        this.redstoneSignalStrength = tag.getInt("signalStrength");
        this.redstoneSignalType = (RedstoneBlockEntity.RedstoneSignalType)((Object)RedstoneBlockEntity.RedstoneSignalType.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("redstone_signal")).result().orElse(Pair.of((Object)((Object)RedstoneBlockEntity.RedstoneSignalType.IGNORED), (Object)new CompoundTag())).getFirst());
    }

    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag movementData = new CompoundTag();
        movementData.putBoolean("backward", this.backward);
        movementData.putFloat("movement", this.movement);
        movementData.putFloat("lastMovement", this.lastMovement);
        tag.put("movementData", (Tag)movementData);
        tag.putBoolean("active", this.active);
        tag.putInt("signalStrength", this.redstoneSignalStrength);
        Optional tag1 = RedstoneBlockEntity.RedstoneSignalType.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.redstoneSignalType).result();
        tag1.ifPresent(value -> tag.put("redstone_signal", value));
    }
}

