/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.blockentities;

import com.thepigcat.buildcraft.api.blocks.PipeBlock;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlockEntity<CAP>
extends BlockEntity {
    public Direction extracting;
    protected final Map<Direction, BlockCapabilityCache<CAP, Direction>> capabilityCaches = new HashMap<Direction, BlockCapabilityCache<CAP, Direction>>(6);
    protected Set<Direction> directions = new ObjectArraySet(6);

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected abstract BlockCapability<CAP, Direction> getCapType();

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Direction[] directions;
            ServerLevel serverLevel = (ServerLevel)level;
            PipeBlock.setPipeProperties(this);
            for (Direction direction : directions = Direction.values()) {
                this.capabilityCaches.put(direction, BlockCapabilityCache.create(this.getCapType(), (ServerLevel)serverLevel, (BlockPos)this.worldPosition.relative(direction), (Object)direction.getOpposite()));
            }
        }
    }

    public void tick() {
    }

    public void setDirections(Set<Direction> directions) {
        this.directions = directions;
    }

    public Set<Direction> getDirections() {
        return this.directions;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

