/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.blocks;

import com.portingdeadmods.portingdeadlibs.api.blocks.ContainerBlock;
import com.thepigcat.buildcraft.api.blockentities.EngineBlockEntity;
import com.thepigcat.buildcraft.util.BlockUtils;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class EngineBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.UP, Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)), Direction.DOWN, Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)), Direction.EAST, Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)), Direction.SOUTH, Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)), Direction.WEST, Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));

    public EngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EngineBlockEntity) {
            EngineBlockEntity engineBlockEntity = (EngineBlockEntity)blockEntity;
            engineBlockEntity.initCaches((Direction)newState.getValue((Property)FACING));
        }
        level.invalidateCapabilities(pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace()) : null;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockUtils.getBE(EngineBlockEntity.class, (BlockGetter)level, pos).emitRedstoneLevel();
    }

    public boolean tickingEnabled() {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        int signal = level.getBestNeighborSignal(pos);
        BlockUtils.getBE(EngineBlockEntity.class, (BlockGetter)level, pos).setRedstoneSignalStrength(signal);
    }
}

