/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.blocks;

import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.api.blockentities.PipeBlockEntity;
import com.thepigcat.buildcraft.util.BlockUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlock
extends BaseEntityBlock {
    public static final EnumProperty<PipeState>[] CONNECTION = new EnumProperty[6];
    public final int border;
    public final VoxelShape shapeCenter;
    public final VoxelShape shapeD;
    public final VoxelShape shapeU;
    public final VoxelShape shapeN;
    public final VoxelShape shapeS;
    public final VoxelShape shapeW;
    public final VoxelShape shapeE;
    public final VoxelShape[] shapes;

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(CONNECTION[0], (Comparable)((Object)PipeState.NONE))).setValue(CONNECTION[1], (Comparable)((Object)PipeState.NONE))).setValue(CONNECTION[2], (Comparable)((Object)PipeState.NONE))).setValue(CONNECTION[3], (Comparable)((Object)PipeState.NONE))).setValue(CONNECTION[4], (Comparable)((Object)PipeState.NONE))).setValue(CONNECTION[5], (Comparable)((Object)PipeState.NONE)));
        int width = 10;
        int B0 = this.border = (16 - width) / 2;
        int B1 = 16 - this.border;
        this.shapeCenter = PipeBlock.box((double)B0, (double)B0, (double)B0, (double)B1, (double)B1, (double)B1);
        this.shapeD = PipeBlock.box((double)B0, (double)0.0, (double)B0, (double)B1, (double)B0, (double)B1);
        this.shapeU = PipeBlock.box((double)B0, (double)B1, (double)B0, (double)B1, (double)16.0, (double)B1);
        this.shapeN = PipeBlock.box((double)B0, (double)B0, (double)0.0, (double)B1, (double)B1, (double)B0);
        this.shapeS = PipeBlock.box((double)B0, (double)B0, (double)B1, (double)B1, (double)B1, (double)16.0);
        this.shapeW = PipeBlock.box((double)0.0, (double)B0, (double)B0, (double)B0, (double)B1, (double)B1);
        this.shapeE = PipeBlock.box((double)B1, (double)B0, (double)B0, (double)16.0, (double)B1, (double)B1);
        this.shapes = new VoxelShape[64];
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int index = 0;
        for (Direction direction : Direction.values()) {
            if (blockState.getValue(CONNECTION[direction.get3DDataValue()]) == PipeState.NONE) continue;
            index |= 1 << direction.get3DDataValue();
        }
        return this.getShape(index);
    }

    public VoxelShape getShape(int i) {
        if (this.shapes[i] == null) {
            this.shapes[i] = this.shapeCenter;
            if ((i >> 0 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeD);
            }
            if ((i >> 1 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeU);
            }
            if ((i >> 2 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeN);
            }
            if ((i >> 3 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeS);
            }
            if ((i >> 4 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeW);
            }
            if ((i >> 5 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeE);
            }
        }
        return this.shapes[i];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.getBlockEntityType().create(blockPos, blockState);
    }

    protected abstract BlockEntityType<? extends PipeBlockEntity<?>> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PipeBlock.createTickerHelper(blockEntityType, this.getBlockEntityType(), (beLevel, bePos, beState, be) -> be.tick());
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION[0], CONNECTION[1], CONNECTION[2], CONNECTION[3], CONNECTION[4], CONNECTION[5]});
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction facingDirection, BlockState facingBlockState, LevelAccessor level, BlockPos blockPos, BlockPos facingBlockPos) {
        int connectionIndex = facingDirection.get3DDataValue();
        PipeBlockEntity pipeBE = BlockUtils.getBE(PipeBlockEntity.class, (BlockGetter)level, blockPos);
        PipeState connectionType = this.getConnectionType(level, blockPos, blockState, facingDirection, facingBlockPos);
        if (connectionType != PipeState.NONE) {
            pipeBE.getDirections().add(facingDirection);
            return (BlockState)blockState.setValue(CONNECTION[connectionIndex], (Comparable)((Object)connectionType));
        }
        if (facingBlockState.isEmpty()) {
            pipeBE.getDirections().remove(facingDirection);
            return (BlockState)blockState.setValue(CONNECTION[connectionIndex], (Comparable)((Object)PipeState.NONE));
        }
        PipeBlock.setPipeProperties(pipeBE, blockState);
        return blockState;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            int connectionIndex = direction.get3DDataValue();
            BlockPos facingBlockPos = blockPos.relative(direction);
            blockState = (BlockState)blockState.setValue(CONNECTION[connectionIndex], (Comparable)((Object)this.getConnectionType((LevelAccessor)level, blockPos, blockState, direction, facingBlockPos)));
        }
        return blockState;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        PipeBlockEntity be = BlockUtils.getBE(PipeBlockEntity.class, (BlockGetter)level, pos);
        PipeBlock.setPipeProperties(be, state);
        level.invalidateCapabilities(pos);
    }

    public static void setPipeProperties(PipeBlockEntity<?> be) {
        PipeBlock.setPipeProperties(be, be.getBlockState());
    }

    public static void setPipeProperties(PipeBlockEntity<?> be, BlockState state) {
        ObjectArraySet directions = new ObjectArraySet();
        for (Direction direction : Direction.values()) {
            PipeState pipeState = (PipeState)((Object)state.getValue(CONNECTION[direction.get3DDataValue()]));
            if (pipeState == PipeState.NONE) continue;
            directions.add(direction);
            if (pipeState != PipeState.EXTRACTING) continue;
            be.extracting = direction;
        }
        BuildcraftLegacy.LOGGER.debug("set Dirs: {}", (Object)directions);
        be.setDirections((Set<Direction>)directions);
    }

    public abstract PipeState getConnectionType(LevelAccessor var1, BlockPos var2, BlockState var3, Direction var4, BlockPos var5);

    static {
        for (Direction dir : Direction.values()) {
            PipeBlock.CONNECTION[dir.get3DDataValue()] = EnumProperty.create((String)dir.getSerializedName(), PipeState.class);
        }
    }

    public static enum PipeState implements StringRepresentable
    {
        EXTRACTING("extracting"),
        CONNECTED("connected"),
        NONE("none");

        private final String name;

        private PipeState(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

