/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.capabilties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thepigcat.buildcraft.BuildcraftLegacy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class JumboItemHandler
implements IItemHandler,
INBTSerializable<Tag> {
    public static final Codec<JumboItemHandler> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BigStack.CODEC.listOf().fieldOf("items").forGetter(JumboItemHandler::getItems), (App)Codec.INT.fieldOf("slotLimit").forGetter(JumboItemHandler::getSlotLimit)).apply((Applicative)builder, JumboItemHandler::new));
    private List<BigStack> items;
    private int slotLimit;

    public JumboItemHandler(int slotLimit) {
        this(1, slotLimit);
    }

    public JumboItemHandler(int slots, int slotLimit) {
        this.slotLimit = slotLimit;
        this.items = new ArrayList<BigStack>();
        for (int i = 0; i < slots; ++i) {
            this.getItems().add(i, new BigStack(ItemStack.EMPTY, 0));
        }
    }

    public JumboItemHandler(List<BigStack> items, int slotLimit) {
        this.items = items;
        this.slotLimit = slotLimit;
    }

    public int getSlots() {
        return this.getItems().size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.getItems().get(slot).getSlotStack();
    }

    public List<BigStack> getItems() {
        return this.items;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            BigStack bigStack = this.getItems().get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.getCount());
            if (!simulate) {
                if (bigStack.getStack().isEmpty()) {
                    bigStack.setStack(stack.copyWithCount(stack.getMaxStackSize()));
                }
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChanged();
            }
            if (inserted == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            return stack.copyWithCount(stack.getCount() - inserted);
        }
        return stack;
    }

    public void onChanged() {
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        BigStack bigStack = this.getItems().get(slot);
        if (bigStack.getStack().isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (bigStack.getAmount() <= amount) {
            ItemStack out = bigStack.getStack().copy();
            int newAmount = bigStack.getAmount();
            if (!simulate) {
                bigStack.setAmount(0);
                bigStack.clear();
                this.onChanged();
            }
            out.setCount(newAmount);
            return out;
        }
        if (!simulate) {
            bigStack.setAmount(bigStack.getAmount() - amount);
            this.onChanged();
        }
        return bigStack.getStack().copyWithCount(amount);
    }

    public int getSlotLimit() {
        return this.slotLimit;
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getItems().size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getItems().size() + ")");
        }
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        DataResult tagDataResult = CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)this);
        if (tagDataResult.isSuccess()) {
            return (Tag)tagDataResult.getOrThrow();
        }
        BuildcraftLegacy.LOGGER.debug("Error encoding jumbo item handler: {}", (Object)((DataResult.Error)tagDataResult.error().get()).message());
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        DataResult pairDataResult = CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)nbt);
        if (pairDataResult.isSuccess()) {
            JumboItemHandler jumboItemHandler = (JumboItemHandler)((Pair)pairDataResult.getOrThrow()).getFirst();
            this.items = jumboItemHandler.getItems();
            this.slotLimit = jumboItemHandler.slotLimit;
        }
    }

    public static class BigStack {
        public static final Codec<BigStack> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("stack").forGetter(BigStack::getEncodeStack), (App)Codec.INT.fieldOf("amount").forGetter(BigStack::getAmount)).apply((Applicative)builder, BigStack::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BigStack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BigStack::getEncodeStack, (StreamCodec)ByteBufCodecs.INT, BigStack::getAmount, BigStack::new);
        public static final BigStack EMPTY = new BigStack(ItemStack.EMPTY, 0);
        private ItemStack stack;
        private ItemStack slotStack;
        private int amount;

        public BigStack(ItemStack stack, int amount) {
            this.stack = stack.copy();
            this.amount = amount;
            this.slotStack = stack.copyWithCount(amount);
        }

        public BigStack(ItemStack stack, ItemStack slotStack, int amount) {
            this.stack = stack.copy();
            this.slotStack = slotStack;
            this.amount = amount;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public ItemStack getEncodeStack() {
            return this.slotStack.copyWithCount(1);
        }

        public ItemStack getSlotStack() {
            return this.slotStack.copyWithCount(this.amount);
        }

        public void setStack(ItemStack stack) {
            this.stack = stack.copy();
            this.slotStack = stack.copyWithCount(this.amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.slotStack.setCount(amount);
        }

        public void clear() {
            this.amount = 0;
            this.slotStack = ItemStack.EMPTY;
            this.stack = ItemStack.EMPTY;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public BigStack copy() {
            return new BigStack(this.stack.copy(), this.slotStack.copy(), this.amount);
        }
    }
}

