/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.api.pipes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thepigcat.buildcraft.api.pipes.PipeType;
import com.thepigcat.buildcraft.registries.BCPipeTypes;
import com.thepigcat.buildcraft.util.PipeRegistrationHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public record Pipe(boolean disabled, ResourceLocation type, Optional<String> name, float transferSpeed, List<ResourceLocation> textures, Either<BlockBehaviour.Properties, ResourceLocation> properties, ResourceLocation dropItem, Ingredient ingredient, List<TagKey<Block>> miningTools, int tabOrdering, boolean customBlockModel, boolean customItemModel, boolean customRecipe, boolean customLoottable, boolean customTags) {
    public static final Codec<Pipe> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("disabled", (Object)false).forGetter(Pipe::disabled), (App)ResourceLocation.CODEC.optionalFieldOf("type", (Object)BCPipeTypes.DEFAULT.key()).forGetter(Pipe::type), (App)Codec.STRING.optionalFieldOf("name").forGetter(Pipe::name), (App)Codec.FLOAT.optionalFieldOf("transfer_speed", (Object)Float.valueOf(0.1f)).forGetter(Pipe::transferSpeed), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("textures", List.of()).forGetter(Pipe::textures), (App)Codec.either((Codec)BlockBehaviour.Properties.CODEC.fieldOf("properties").codec(), (Codec)ResourceLocation.CODEC.fieldOf("copy_of").codec()).optionalFieldOf("properties", (Object)Either.right((Object)ResourceLocation.parse((String)"cobblestone"))).forGetter(Pipe::properties), (App)ResourceLocation.CODEC.optionalFieldOf("drop_item", (Object)ResourceLocation.parse((String)"air")).forGetter(Pipe::dropItem), (App)Ingredient.CODEC.optionalFieldOf("ingredient", (Object)Ingredient.EMPTY).forGetter(Pipe::ingredient), (App)TagKey.codec((ResourceKey)Registries.BLOCK).listOf().optionalFieldOf("mining_tools", List.of()).forGetter(Pipe::miningTools), (App)Codec.INT.optionalFieldOf("tab_ordering_priority", (Object)-1).forGetter(Pipe::tabOrdering), (App)Codec.BOOL.optionalFieldOf("has_custom_block_model", (Object)false).forGetter(Pipe::customBlockModel), (App)Codec.BOOL.optionalFieldOf("has_custom_item_model", (Object)false).forGetter(Pipe::customItemModel), (App)Codec.BOOL.optionalFieldOf("has_custom_recipe", (Object)false).forGetter(Pipe::customRecipe), (App)Codec.BOOL.optionalFieldOf("has_custom_loottable", (Object)false).forGetter(Pipe::customLoottable), (App)Codec.BOOL.optionalFieldOf("has_custom_tags", (Object)false).forGetter(Pipe::customTags)).apply((Applicative)inst, Pipe::new));

    public static Pipe fromJson(JsonElement json) {
        DataResult decodeResult = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (decodeResult.isSuccess()) {
            return (Pipe)((Pair)decodeResult.getOrThrow()).getFirst();
        }
        return null;
    }

    public JsonElement toJson() {
        DataResult encodeResult = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        if (encodeResult.isSuccess()) {
            return (JsonElement)encodeResult.getOrThrow();
        }
        return null;
    }

    public PipeType<?, ?> getType() {
        return PipeRegistrationHelper.PIPE_TYPES.getOrDefault(this.type, BCPipeTypes.DEFAULT.value());
    }

    public Collection<? extends TagKey<Block>> getMiningTools() {
        return this.miningTools;
    }
}

