/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.client.screens.widgets;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemButton
extends AbstractButton {
    public static final int ITEM_SIZE = 16;
    private ItemStack item;
    private final Consumer<ItemButton> onPressFunction;

    public ItemButton(Item item, int x, int y, int width, int height, Consumer<ItemButton> onPressFunction) {
        super(x, y, width, height, (Component)Component.empty());
        this.item = new ItemStack((ItemLike)item);
        this.onPressFunction = onPressFunction;
    }

    public Item getItem() {
        return this.item.getItem();
    }

    public void setItem(Item item) {
        this.item = new ItemStack((ItemLike)item);
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.renderItem(this.item, (int)((float)this.getX() + (float)(this.width - 16) / 2.0f), (int)((float)this.getY() + (float)(this.height - 16) / 2.0f));
    }

    public void onPress() {
        this.onPressFunction.accept(this);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

