/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.client.screens.widgets;

import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.api.blockentities.RedstoneBlockEntity;
import com.thepigcat.buildcraft.client.screens.widgets.LazyImageButton;
import com.thepigcat.buildcraft.networking.RedstoneSignalTypeSyncPayload;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class RedstoneWidget
extends AbstractWidget {
    public static final ResourceLocation WIDGET_SPRITE = BuildcraftLegacy.rl("widget/widget_redstone_control_right");
    public static final ResourceLocation WIDGET_OPEN_SPRITE = BuildcraftLegacy.rl("widget/redstone_widget_open");
    public static final int WIDGET_WIDTH = 32;
    public static final int WIDGET_HEIGHT = 32;
    public static final int WIDGET_OPEN_WIDTH = 80;
    public static final int WIDGET_OPEN_HEIGHT = 80;
    public static final ItemStack REDSTONE_STACK = new ItemStack((ItemLike)Items.REDSTONE);
    private final LazyImageButton[] buttons;
    private final LazyImageButton buttonNoControl;
    private final LazyImageButton buttonLowSignal;
    private final LazyImageButton buttonHighSignal;
    private boolean open;
    private RedstoneBlockEntity redstoneBlockEntity;

    public RedstoneWidget(RedstoneBlockEntity blockEntity, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        int y1 = y + 28;
        this.buttonNoControl = new LazyImageButton(BuildcraftLegacy.rl("redstone"), 16, 16, x + 7, y1, 18, 18, btn -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new RedstoneSignalTypeSyncPayload(this.redstoneBlockEntity.self().getBlockPos(), RedstoneBlockEntity.RedstoneSignalType.IGNORED), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.setFocusForButton(RedstoneBlockEntity.RedstoneSignalType.IGNORED);
        });
        this.buttonNoControl.visible = false;
        this.buttonNoControl.setHoverText((Component)Component.literal((String)"Ignored"));
        this.buttonLowSignal = new LazyImageButton(BuildcraftLegacy.rl("redstone_torch_off"), 16, 16, x + 7 + 22, y1, 18, 18, btn -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new RedstoneSignalTypeSyncPayload(this.redstoneBlockEntity.self().getBlockPos(), RedstoneBlockEntity.RedstoneSignalType.LOW_SIGNAL), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.setFocusForButton(RedstoneBlockEntity.RedstoneSignalType.LOW_SIGNAL);
        });
        this.buttonLowSignal.visible = false;
        this.buttonLowSignal.setHoverText((Component)Component.literal((String)"Low"));
        this.buttonHighSignal = new LazyImageButton(BuildcraftLegacy.rl("redstone_torch_on"), 16, 16, x + 7 + 44, y1, 18, 18, btn -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new RedstoneSignalTypeSyncPayload(this.redstoneBlockEntity.self().getBlockPos(), RedstoneBlockEntity.RedstoneSignalType.HIGH_SIGNAL), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.setFocusForButton(RedstoneBlockEntity.RedstoneSignalType.HIGH_SIGNAL);
        });
        this.buttonHighSignal.visible = false;
        this.buttonHighSignal.setHoverText((Component)Component.literal((String)"High"));
        this.buttons = new LazyImageButton[]{this.buttonNoControl, this.buttonLowSignal, this.buttonHighSignal};
        this.open = false;
        this.redstoneBlockEntity = blockEntity;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean isHovered;
        boolean bl = isHovered = mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + 32) && mouseY < (double)(this.getY() + 32);
        if (isHovered && !this.buttonNoControl.isHovered() && !this.buttonLowSignal.isHovered() && !this.buttonHighSignal.isHovered()) {
            this.buttonNoControl.visible = this.open = !this.open;
            this.buttonLowSignal.visible = this.open;
            this.buttonHighSignal.visible = this.open;
            if (this.open) {
                this.setFocusForButtons();
            }
            if (this.open) {
                this.setSize(80, 80);
            } else {
                this.setSize(32, 32);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        for (LazyImageButton button : this.getButtons()) {
            consumer.accept((AbstractWidget)button);
        }
    }

    private void setFocusForButton(RedstoneBlockEntity.RedstoneSignalType signalType) {
        for (LazyImageButton redstoneButton : this.buttons) {
            redstoneButton.setFocused(false);
        }
        LazyImageButton redstoneButton = this.getButtonBySignalType(signalType);
        redstoneButton.setFocused(true);
    }

    private void setFocusForButtons() {
        for (LazyImageButton redstoneButton : this.buttons) {
            redstoneButton.setFocused(false);
        }
        LazyImageButton redstoneButton = this.getButtonBySignalType(this.redstoneBlockEntity.getRedstoneSignalType());
        redstoneButton.setFocused(true);
    }

    private LazyImageButton getButtonBySignalType(RedstoneBlockEntity.RedstoneSignalType signalType) {
        return switch (signalType) {
            default -> throw new MatchException(null, null);
            case RedstoneBlockEntity.RedstoneSignalType.IGNORED -> this.buttonNoControl;
            case RedstoneBlockEntity.RedstoneSignalType.LOW_SIGNAL -> this.buttonLowSignal;
            case RedstoneBlockEntity.RedstoneSignalType.HIGH_SIGNAL -> this.buttonHighSignal;
        };
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        if (this.open) {
            Font font = Minecraft.getInstance().font;
            guiGraphics.blitSprite(WIDGET_OPEN_SPRITE, this.getX(), this.getY(), 80, 80);
            guiGraphics.renderFakeItem(REDSTONE_STACK, this.getX() + 3, this.getY() + 8);
            guiGraphics.drawString(font, (Component)Component.literal((String)"Redstone").withStyle(ChatFormatting.WHITE), this.getX() + 20, this.getY() + 13, -1);
            guiGraphics.drawString(font, (Component)Component.literal((String)"Signal").withStyle(ChatFormatting.GRAY), this.getX() + 5, this.getY() + 54, -1);
            RedstoneBlockEntity.RedstoneSignalType signalType = this.redstoneBlockEntity.getRedstoneSignalType();
            if (signalType == null) {
                signalType = RedstoneBlockEntity.RedstoneSignalType.IGNORED;
            }
            MutableComponent mutableComponent = Component.translatable((String)("redstone_signal_type.buildcraft." + signalType.getSerializedName())).withStyle(ChatFormatting.WHITE);
            int n = this.getX() + 5;
            int n2 = this.getY() + 54;
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, (Component)mutableComponent, n, n2 + 9 + 2, -1);
        } else {
            guiGraphics.blitSprite(WIDGET_SPRITE, this.getX(), this.getY(), 32, 32);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public LazyImageButton[] getButtons() {
        return this.buttons;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }
}

