/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.api.blockentities.EngineBlockEntity;
import com.thepigcat.buildcraft.content.menus.CombustionEngineMenu;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import com.thepigcat.buildcraft.tags.BCTags;
import com.thepigcat.buildcraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombustionEngineBE
extends EngineBlockEntity
implements MenuProvider {
    private int burnProgress;

    public CombustionEngineBE(BlockPos blockPos, BlockState blockState) {
        super(BCBlockEntities.COMBUSTION_ENGINE.get(), blockPos, blockState);
        this.addFluidHandler(HandlerUtils::newFluidTank, builder -> (ContainerBlockEntity.FluidHandlerBuilder)builder.slotLimit($ -> BCConfig.combustionEngineFluidCapacity).validator((tank, fluid) -> fluid.is(BCTags.Fluids.COMBUSTION_FUEL)));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getRedstoneSignalType().isActive(this.getRedstoneSignalStrength())) {
            IFluidHandler fluidHandler = this.getFluidHandler();
            if (!fluidHandler.getFluidInTank(0).isEmpty()) {
                ++this.burnProgress;
                if (!this.level.isClientSide()) {
                    this.getEnergyStorage().receiveEnergy(this.getEnergyProduction(), false);
                    if (this.burnProgress % 15 == 0) {
                        fluidHandler.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            } else {
                this.burnProgress = 0;
            }
        }
    }

    @Override
    public int getEnergyCapacity() {
        return BCConfig.combustionEngineEnergyCapacity;
    }

    @Override
    public int getEnergyProduction() {
        return BCConfig.combustionEngineEnergyProduction;
    }

    @Override
    public boolean isActive() {
        return this.burnProgress > 0 && this.getRedstoneSignalType().isActive(this.getRedstoneSignalStrength());
    }

    public int getBurnProgress() {
        return this.burnProgress;
    }

    @Override
    public int emitRedstoneLevel() {
        return BlockUtils.calcRedstoneFromTank(this.getFluidHandler());
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Combustion Engine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CombustionEngineMenu(containerId, playerInventory, this);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.burnProgress = tag.getInt("burnProgress");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("burnProgress", this.burnProgress);
    }
}

