/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.api.capabilties.JumboItemHandler;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBE
extends BlockEntity {
    private final JumboItemHandler itemHandler = new JumboItemHandler(BCConfig.crateItemCapacity){

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            ItemStack stackInSlot = this.getStackInSlot(slot);
            return stackInSlot.isEmpty() || stack.is(stackInSlot.getItem()) && stack.getCount() + stackInSlot.getCount() < this.getSlotLimit(slot);
        }

        @Override
        public void onChanged() {
            CrateBE.this.setChanged();
            if (!CrateBE.this.level.isClientSide()) {
                CrateBE.this.level.sendBlockUpdated(CrateBE.this.getBlockPos(), CrateBE.this.getBlockState(), CrateBE.this.getBlockState(), 3);
            }
        }
    };

    public CrateBE(BlockPos pos, BlockState blockState) {
        super(BCBlockEntities.CRATE.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, (Tag)tag.getCompound("item_handler"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("item_handler", this.itemHandler.serializeNBT(registries));
    }

    public JumboItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public JumboItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

