/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.thepigcat.buildcraft.content.blockentities.ItemPipeBE;
import com.thepigcat.buildcraft.networking.SyncPipeDirectionPayload;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExtractItemPipeBE
extends ItemPipeBE {
    public ExtractItemPipeBE(BlockPos pos, BlockState blockState) {
        super(BCBlockEntities.EXTRACTING_ITEM_PIPE.get(), pos, blockState);
    }

    @Override
    public void tick() {
        IItemHandler extractingHandler;
        BlockCapabilityCache cache;
        if (!this.level.isClientSide() && this.level.getGameTime() % 50L == 0L && (cache = (BlockCapabilityCache)this.capabilityCaches.get(this.extracting)) != null && (extractingHandler = (IItemHandler)cache.getCapability()) != null) {
            ItemStack extractedStack = ItemStack.EMPTY;
            int extractedSlot = 0;
            for (int i = 0; i < extractingHandler.getSlots(); ++i) {
                ItemStack stack = extractingHandler.extractItem(i, 64, false);
                if (stack.isEmpty()) continue;
                extractedStack = stack;
                extractedSlot = i;
                break;
            }
            if (!extractedStack.isEmpty()) {
                ItemStack insertRemainder = this.itemHandler.insertItem(0, extractedStack, false);
                extractingHandler.insertItem(extractedSlot, insertRemainder, false);
                this.setFrom(this.extracting);
                ArrayList directions = new ArrayList(this.directions);
                directions.remove(this.extracting);
                if (!directions.isEmpty()) {
                    this.setTo((Direction)directions.getFirst());
                }
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeDirectionPayload(this.worldPosition, Optional.ofNullable(this.from), Optional.ofNullable(this.to)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        super.tick();
    }
}

