/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.api.blockentities.PipeBlockEntity;
import com.thepigcat.buildcraft.networking.SyncPipeDirectionPayload;
import com.thepigcat.buildcraft.networking.SyncPipeMovementPayload;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import com.thepigcat.buildcraft.util.BlockUtils;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemPipeBE
extends PipeBlockEntity<IItemHandler> {
    protected final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ItemPipeBE.this.setChanged();
            if (!ItemPipeBE.this.level.isClientSide()) {
                ItemPipeBE.this.level.sendBlockUpdated(ItemPipeBE.this.getBlockPos(), ItemPipeBE.this.getBlockState(), ItemPipeBE.this.getBlockState(), 3);
            }
        }
    };
    protected Direction from;
    protected Direction to;
    private Direction prevFrom;
    public float movement;
    public float lastMovement;

    public ItemPipeBE(BlockPos pos, BlockState blockState) {
        this(BCBlockEntities.ITEM_PIPE.get(), pos, blockState);
    }

    public ItemPipeBE(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    protected BlockCapability<IItemHandler, Direction> getCapType() {
        return Capabilities.ItemHandler.BLOCK;
    }

    @Override
    public void tick() {
        IItemHandler insertingHandler;
        if (!this.level.isClientSide() && this.movement >= 1.0f && this.to != null && (insertingHandler = (IItemHandler)((BlockCapabilityCache)this.capabilityCaches.get(this.to)).getCapability()) != null) {
            ItemStack pipeContent = insertingHandler.getStackInSlot(0);
            if (!(this.level.getBlockEntity(this.worldPosition.relative(this.to)) instanceof ItemPipeBE)) {
                pipeContent = ItemStack.EMPTY;
            }
            if (pipeContent.isEmpty()) {
                ItemStack remainder = this.insertItems(insertingHandler);
                BuildcraftLegacy.LOGGER.debug("remainder: {}", (Object)remainder);
                this.itemHandler.insertItem(0, remainder, false);
                ItemPipeBE blockEntity = BlockUtils.getBE(ItemPipeBE.class, (BlockGetter)this.level, this.worldPosition.relative(this.to));
                if (blockEntity != null) {
                    this.moveItemForward(blockEntity);
                }
                if (!remainder.isEmpty()) {
                    this.moveItemBackward();
                }
            } else {
                this.moveItemBackward();
            }
        }
        if (!this.itemHandler.getStackInSlot(0).isEmpty()) {
            this.lastMovement = this.movement;
            this.movement += 0.01f;
            if (!this.level.isClientSide()) {
                BlockCapabilityCache fromCache = (BlockCapabilityCache)this.capabilityCaches.get(this.from);
                BlockCapabilityCache toCache = (BlockCapabilityCache)this.capabilityCaches.get(this.to);
                if (toCache == null || toCache.getCapability() == null) {
                    if (fromCache == null || fromCache.getCapability() == null) {
                        this.lastMovement = 0.0f;
                        this.movement = 0.0f;
                        this.setTo(null);
                        this.setFrom(null);
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeDirectionPayload(this.worldPosition, Optional.empty(), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeMovementPayload(this.worldPosition, this.movement, this.lastMovement), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        this.moveItemBackward(1.0f - this.lastMovement, 1.0f - this.movement);
                    }
                }
            }
        } else {
            this.lastMovement = 0.0f;
            this.movement = 0.0f;
        }
    }

    public void setFrom(Direction from) {
        this.prevFrom = this.from;
        this.from = from;
    }

    public void setTo(Direction to) {
        this.to = to;
    }

    public Direction getFrom() {
        return this.from;
    }

    public Direction getTo() {
        return this.to;
    }

    private void moveItemForward(ItemPipeBE blockEntity) {
        HashSet directions = new HashSet(blockEntity.directions);
        directions.remove(this.to.getOpposite());
        blockEntity.setFrom(this.to.getOpposite());
        if (!directions.isEmpty()) {
            int dirIndex = this.level.random.nextInt(0, directions.size());
            blockEntity.setTo((Direction)directions.stream().toList().get(dirIndex));
        } else {
            blockEntity.setTo(blockEntity.from);
        }
        blockEntity.lastMovement = Math.abs(1.0f - this.lastMovement);
        blockEntity.movement = Math.abs(1.0f - this.movement);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeMovementPayload(blockEntity.getBlockPos(), blockEntity.movement, blockEntity.lastMovement), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeDirectionPayload(blockEntity.getBlockPos(), Optional.ofNullable(blockEntity.from), Optional.ofNullable(blockEntity.to)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void moveItemBackward() {
        this.moveItemBackward(0.0f, 0.0f);
    }

    private void moveItemBackward(float lastMovement, float movement) {
        Direction to = this.to;
        this.setTo(this.from);
        this.setFrom(to);
        this.lastMovement = lastMovement;
        this.movement = movement;
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeMovementPayload(this.worldPosition, this.movement, this.lastMovement), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPipeDirectionPayload(this.worldPosition, Optional.ofNullable(this.from), Optional.ofNullable(this.to)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private ItemStack insertItems(IItemHandler insertingHandler) {
        ItemStack toInsert = this.itemHandler.extractItem(0, this.itemHandler.getSlotLimit(0), false);
        return ItemHandlerHelper.insertItem((IItemHandler)insertingHandler, (ItemStack)toInsert, (boolean)false);
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        int fromIndex;
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("item_handler"));
        int toIndex = tag.getInt("to");
        if (toIndex != -1) {
            this.setTo(Direction.values()[toIndex]);
        }
        if ((fromIndex = tag.getInt("from")) != -1) {
            this.setFrom(Direction.values()[fromIndex]);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("item_handler", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("to", this.to != null ? this.to.ordinal() : -1);
        tag.putInt("from", this.from != null ? this.from.ordinal() : -1);
    }
}

