/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.api.blockentities.EngineBlockEntity;
import com.thepigcat.buildcraft.content.menus.StirlingEngineMenu;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StirlingEngineBE
extends EngineBlockEntity
implements MenuProvider {
    private int burnTime;
    private int burnProgress;

    public StirlingEngineBE(BlockPos blockPos, BlockState blockState) {
        super(BCBlockEntities.STIRLING_ENGINE.get(), blockPos, blockState);
        this.addItemHandler(HandlerUtils::newItemStackHandler, builder -> (ContainerBlockEntity.ItemHandlerBuilder)((ContainerBlockEntity.ItemHandlerBuilder)builder.onChange(this::onItemsChanged)).slots(1).validator((slot, item) -> item.getBurnTime(RecipeType.SMELTING) > 0));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnProgress() {
        return this.burnProgress;
    }

    @Override
    public int getEnergyCapacity() {
        return BCConfig.stirlingEngineEnergyCapacity;
    }

    @Override
    public int getEnergyProduction() {
        return BCConfig.stirlingEngineEnergyProduction;
    }

    public void onItemsChanged(int slot) {
        ItemStack stack;
        int burnProgress;
        IItemHandler itemHandler = this.getItemHandler();
        if (itemHandler != null && (burnProgress = (stack = itemHandler.getStackInSlot(slot)).getBurnTime(RecipeType.SMELTING)) > 0 && this.burnProgress <= 0) {
            this.burnProgress = burnProgress;
            this.burnTime = burnProgress;
            itemHandler.extractItem(0, 1, false);
        }
    }

    @Override
    public boolean isActive() {
        return this.getBurnProgress() > 0 && this.getRedstoneSignalType().isActive(this.getRedstoneSignalStrength());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getRedstoneSignalType().isActive(this.getRedstoneSignalStrength())) {
            IItemHandler itemHandler = this.getItemHandler();
            if (this.burnProgress > 0) {
                --this.burnProgress;
                this.getEnergyStorage().receiveEnergy(1, false);
            } else {
                this.burnTime = 0;
                ItemStack stack = itemHandler.getStackInSlot(0);
                int burnProgress = stack.getBurnTime(RecipeType.SMELTING);
                if (burnProgress > 0) {
                    this.burnProgress = burnProgress;
                    this.burnTime = burnProgress;
                    itemHandler.extractItem(0, 1, false);
                }
            }
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Stirling Engine");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new StirlingEngineMenu(containerId, playerInventory, this);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.burnProgress = tag.getInt("burnProgress");
        this.burnTime = tag.getInt("burnTime");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("burnProgress", this.burnProgress);
        tag.putInt("burnTime", this.burnTime);
    }

    @Override
    public int emitRedstoneLevel() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.getItemHandler());
    }
}

