/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blockentities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.capabilities.DynamicFluidTank;
import com.portingdeadmods.portingdeadlibs.utils.capabilities.HandlerUtils;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.data.BCDataComponents;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import com.thepigcat.buildcraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TankBE
extends ContainerBlockEntity {
    private BlockPos bottomTankPos;
    private boolean topJoined;
    private boolean bottomJoined;
    public FluidStack initialFluid;

    public TankBE(BlockPos pos, BlockState blockState) {
        super(BCBlockEntities.TANK.get(), pos, blockState);
        this.addFluidHandler(HandlerUtils::newDynamicFluidTank, builder -> ((ContainerBlockEntity.FluidHandlerBuilder)builder.onChange($ -> this.updateData())).slotLimit($ -> BCConfig.tankCapacity));
    }

    public FluidStack getFluid() {
        return this.getFluidHandler().getFluidInTank(0);
    }

    public DynamicFluidTank getFluidTank() {
        return (DynamicFluidTank)super.getFluidHandler();
    }

    public IFluidHandler getFluidHandler() {
        if (this.bottomTankPos != null) {
            if (this.bottomTankPos.equals((Object)this.worldPosition)) {
                return this.getFluidTank();
            }
            TankBE tankBE = BlockUtils.getBE(TankBE.class, (BlockGetter)this.level, this.bottomTankPos);
            if (tankBE != null) {
                return tankBE.getFluidHandler();
            }
            return this.getFluidTank();
        }
        return this.getFluidTank();
    }

    public void setBottomTankPos(BlockPos bottomTankPos) {
        this.bottomTankPos = bottomTankPos;
        this.updateData();
    }

    public void initTank(int tanks) {
        this.getFluidTank().setCapacity(tanks * BCConfig.tankCapacity);
        if (this.initialFluid != null) {
            this.getFluidTank().setFluid(this.initialFluid);
            this.initialFluid = null;
        }
        this.updateData();
    }

    public BlockPos getBottomTankPos() {
        return this.bottomTankPos;
    }

    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.bottomTankPos = BlockPos.of((long)tag.getLong("bottomTankPos"));
    }

    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        if (this.bottomTankPos != null) {
            tag.putLong("bottomTankPos", this.bottomTankPos.asLong());
        }
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        super.saveToItem(stack, registries);
        stack.set(BCDataComponents.TANK_CONTENT.get(), (Object)SimpleFluidContent.copyOf((FluidStack)this.getFluidTank().getFluid()));
    }

    public void setTopJoined(boolean topJoined) {
        this.topJoined = topJoined;
    }

    public void setBottomJoined(boolean bottomJoined) {
        this.bottomJoined = bottomJoined;
    }

    public boolean isTopJoined() {
        return this.topJoined;
    }

    public boolean isBottomJoined() {
        return this.bottomJoined;
    }
}

