/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blocks;

import com.mojang.serialization.MapCodec;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.content.blockentities.CrateBE;
import com.thepigcat.buildcraft.data.BCDataComponents;
import com.thepigcat.buildcraft.data.components.BigStackContainerContents;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import com.thepigcat.buildcraft.util.BlockUtils;
import com.thepigcat.buildcraft.util.CapabilityUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public CrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CrateBlock.simpleCodec(CrateBlock::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BCBlockEntities.CRATE.get().create(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return CrateBlock.stateForFacingPlacement((Block)this, context);
    }

    public static BlockState stateForFacingPlacement(Block block, BlockPlaceContext ctx) {
        return (BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getPlayer().getDirection().getOpposite());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock()) && !BCConfig.crateRetainItems) {
            CrateBE crateBE = BlockUtils.getBE(CrateBE.class, (BlockGetter)level, pos);
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{crateBE.getItemHandler().getStackInSlot(0)}));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof CrateBE) {
            CrateBE be = (CrateBE)((Object)object);
            if (BCConfig.crateRetainItems) {
                ItemStack stack = new ItemStack((ItemLike)this);
                if (!be.getItemHandler().getStackInSlot(0).isEmpty()) {
                    stack.set(BCDataComponents.CRATE_CONTENT, (Object)BigStackContainerContents.fromItems(be.getItemHandler().getItems(), be.getItemHandler().getSlotLimit()));
                }
                return List.of(stack);
            }
        }
        return super.getDrops(state, params);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackInSlot;
        IItemHandler itemHandler;
        BlockEntity be = level.getBlockEntity(pos);
        if (be != null && (itemHandler = CapabilityUtils.itemHandlerCapability(be)) != null && (ItemStack.isSameItemSameComponents((ItemStack)(stackInSlot = itemHandler.getStackInSlot(0)).copyWithCount(1), (ItemStack)stack.copyWithCount(1)) || stackInSlot.isEmpty())) {
            ItemStack remainder = itemHandler.insertItem(0, stack, false);
            player.setItemInHand(hand, remainder);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

