/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.blocks.ContainerBlock;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.content.blockentities.TankBE;
import com.thepigcat.buildcraft.data.BCDataComponents;
import com.thepigcat.buildcraft.registries.BCBlockEntities;
import com.thepigcat.buildcraft.util.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankBlock
extends ContainerBlock {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty TOP_JOINED = BooleanProperty.create((String)"top_joined");
    public static final BooleanProperty BOTTOM_JOINED = BooleanProperty.create((String)"bottom_joined");

    public TankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP_JOINED, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM_JOINED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean tickingEnabled() {
        return false;
    }

    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return BCBlockEntities.TANK.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return TankBlock.simpleCodec(TankBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TOP_JOINED, BOTTOM_JOINED}));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        TankBE be = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        IFluidHandler itemFluidHandler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        IFluidHandler tankFluidHandler = be.getFluidHandler();
        if (itemFluidHandler != null && !(stack.getItem() instanceof BucketItem)) {
            FluidStack fluidInItemTank = itemFluidHandler.getFluidInTank(0);
            IFluidHandler fluidHandler0 = tankFluidHandler;
            IFluidHandler fluidHandler1 = itemFluidHandler;
            if (!fluidInItemTank.isEmpty()) {
                fluidInItemTank.getFluid().getPickupSound().ifPresent(arg_0 -> ((Player)player).playSound(arg_0));
                fluidHandler0 = itemFluidHandler;
                fluidHandler1 = tankFluidHandler;
            } else {
                SoundEvent sound = tankFluidHandler.getFluidInTank(0).getFluidType().getSound(SoundActions.BUCKET_EMPTY);
                if (sound != null) {
                    player.playSound(sound);
                }
            }
            FluidStack drained = fluidHandler0.drain(fluidHandler0.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            int filled = fluidHandler1.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            fluidHandler0.fill(drained.copyWithAmount(drained.getAmount() - filled), IFluidHandler.FluidAction.EXECUTE);
            return ItemInteractionResult.SUCCESS;
        }
        if (itemFluidHandler != null && stack.getItem() instanceof BucketItem) {
            FluidStack fluidInItemTank = itemFluidHandler.getFluidInTank(0);
            if (fluidInItemTank.isEmpty() && tankFluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                ItemStack filledBucket = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)tankFluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE).getFluid().getBucket().getDefaultInstance());
                player.setItemInHand(hand, filledBucket);
                tankFluidHandler.getFluidInTank(0).getFluid().getPickupSound().ifPresent(arg_0 -> ((Player)player).playSound(arg_0));
                return ItemInteractionResult.SUCCESS;
            }
            if (!fluidInItemTank.isEmpty() && tankFluidHandler.fill(fluidInItemTank.copyWithAmount(1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                tankFluidHandler.fill(fluidInItemTank.copyWithAmount(1000), IFluidHandler.FluidAction.EXECUTE);
                ItemStack emptyBucket = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)BucketItem.getEmptySuccessItem((ItemStack)stack, (Player)player));
                player.setItemInHand(hand, emptyBucket);
                SoundEvent sound = tankFluidHandler.getFluidInTank(0).getFluidType().getSound(SoundActions.BUCKET_EMPTY);
                if (sound != null) {
                    player.playSound(sound);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (!level.isClientSide()) {
            player.sendSystemMessage((Component)Component.literal((String)("Bottom pos: " + String.valueOf(BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos).getBottomTankPos()))));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        TankBE tankBE;
        boolean bottomJoined;
        TankBE tankBE2;
        BlockState state = super.getStateForPlacement(context);
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        FluidStack itemTankFluid = ((SimpleFluidContent)context.getItemInHand().getOrDefault(BCDataComponents.TANK_CONTENT, (Object)SimpleFluidContent.EMPTY)).copy();
        BlockEntity blockEntity = level.getBlockEntity(clickedPos.above());
        boolean topJoined = blockEntity instanceof TankBE && ((tankBE2 = (TankBE)blockEntity).getFluid().is(itemTankFluid.getFluid()) || tankBE2.getFluid().isEmpty() || itemTankFluid.isEmpty());
        BlockEntity blockEntity2 = level.getBlockEntity(clickedPos.below());
        boolean bl = bottomJoined = blockEntity2 instanceof TankBE && ((tankBE = (TankBE)blockEntity2).getFluid().is(itemTankFluid.getFluid()) || tankBE.getFluid().isEmpty() || itemTankFluid.isEmpty());
        if (topJoined && bottomJoined) {
            TankBE aboveTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, clickedPos.above());
            TankBE belowTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, clickedPos.below());
            if (!aboveTank.getFluid().is(belowTank.getFluid().getFluid()) || !aboveTank.getFluid().is(itemTankFluid.getFluid())) {
                topJoined = false;
            }
        }
        return state != null ? (BlockState)((BlockState)state.setValue((Property)TOP_JOINED, (Comparable)Boolean.valueOf(topJoined))).setValue((Property)BOTTOM_JOINED, (Comparable)Boolean.valueOf(bottomJoined)) : null;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        TankBE tankBE = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        FluidStack fluidInTank = tankBE.getFluidHandler().getFluidInTank(0);
        boolean value = neighborState.is((Block)this);
        if (direction == Direction.UP) {
            if (value) {
                FluidStack fluidInTank1 = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.above()).getFluidHandler().getFluidInTank(0);
                value = fluidInTank1.is(fluidInTank.getFluid()) || fluidInTank.isEmpty() || fluidInTank1.isEmpty();
            }
            tankBE.setTopJoined(value);
            return (BlockState)state.setValue((Property)TOP_JOINED, (Comparable)Boolean.valueOf(value));
        }
        if (direction == Direction.DOWN) {
            if (value) {
                FluidStack fluidInTank1 = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.below()).getFluidHandler().getFluidInTank(0);
                value = fluidInTank1.is(fluidInTank.getFluid()) || fluidInTank.isEmpty() || fluidInTank1.isEmpty();
            }
            tankBE.setBottomJoined(value);
            return (BlockState)state.setValue((Property)BOTTOM_JOINED, (Comparable)Boolean.valueOf(value));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        int aboveFluidAmount = 0;
        if (((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue()) {
            TankBE aboveTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.above());
            aboveFluidAmount = aboveTank.getFluidHandler().getFluidInTank(0).getAmount();
        }
        TankBE tankBE = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        FluidStack baseFluidCopy = tankBE.getFluidTank().getFluid().copy();
        int baseFluidAmount = tankBE.getFluidTank().getFluid().getAmount();
        tankBE.setTopJoined((Boolean)state.getValue((Property)TOP_JOINED));
        tankBE.setBottomJoined((Boolean)state.getValue((Property)BOTTOM_JOINED));
        if (!((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue() && !((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue()) {
            tankBE.setBottomTankPos(pos);
            tankBE.initTank(1);
            return;
        }
        BlockPos bottomPos = pos;
        if (((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
            while (((Boolean)level.getBlockState(bottomPos).getValue((Property)BOTTOM_JOINED)).booleanValue()) {
                bottomPos = bottomPos.below();
            }
        }
        BlockPos curPos = bottomPos;
        while (((Boolean)level.getBlockState(curPos).getValue((Property)TOP_JOINED)).booleanValue()) {
            BlockUtils.getBE(TankBE.class, (BlockGetter)level, curPos).setBottomTankPos(bottomPos);
            curPos = curPos.above();
        }
        BlockUtils.getBE(TankBE.class, (BlockGetter)level, curPos).setBottomTankPos(bottomPos);
        BlockPos topPos = curPos;
        int yDiff = topPos.getY() - bottomPos.getY();
        TankBE bottomTankBe = BlockUtils.getBE(TankBE.class, (BlockGetter)level, bottomPos);
        if (!state.is(oldState.getBlock()) && ((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
            FluidStack fluidInTank = bottomTankBe.getFluidHandler().getFluidInTank(0);
            int amount = fluidInTank.getAmount();
            if (fluidInTank.isEmpty()) {
                fluidInTank = baseFluidCopy;
            }
            bottomTankBe.initialFluid = fluidInTank.copyWithAmount(amount + aboveFluidAmount + baseFluidAmount);
        } else if (!state.is(oldState.getBlock()) && ((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && !((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
            FluidStack fluidInTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.above()).getFluidTank().getFluidInTank(0);
            int amount = fluidInTank.getAmount();
            if (fluidInTank.isEmpty()) {
                fluidInTank = baseFluidCopy;
            }
            bottomTankBe.initialFluid = fluidInTank.copyWithAmount(amount + baseFluidAmount);
        } else if (!state.is(oldState.getBlock()) && !((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
            FluidStack fluidInTank = bottomTankBe.getFluidTank().getFluidInTank(0);
            int amount = fluidInTank.getAmount();
            if (fluidInTank.isEmpty()) {
                fluidInTank = baseFluidCopy;
            }
            bottomTankBe.initialFluid = fluidInTank.copyWithAmount(amount + baseFluidAmount);
        }
        bottomTankBe.initTank(yDiff + 1);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            if (((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
                TankBlock.splitTank(level, pos);
            } else if (((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && !((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
                TankBlock.moveFluidsAbove(level, pos);
            } else if (!((Boolean)state.getValue((Property)TOP_JOINED)).booleanValue() && ((Boolean)state.getValue((Property)BOTTOM_JOINED)).booleanValue()) {
                TankBlock.removeFluidFromBottomTank(level, pos);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private static void removeFluidFromBottomTank(Level level, BlockPos pos) {
        TankBE removedTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        FluidStack fluidStack = removedTank.getFluidHandler().getFluidInTank(0);
        int tank = removedTank.getBlockPos().getY() - removedTank.getBottomTankPos().getY();
        int prevFluidAmount = tank * BCConfig.tankCapacity;
        int fluidAmount = Math.min(fluidStack.getAmount() - prevFluidAmount, BCConfig.tankCapacity);
        removedTank.getFluidHandler().drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
    }

    private static void moveFluidsAbove(Level level, BlockPos pos) {
        TankBE removedTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        TankBE aboveTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.above());
        FluidStack fluidInTank = removedTank.getFluidTank().getFluidInTank(0);
        int amount = Math.max(fluidInTank.getAmount() - BCConfig.tankCapacity, 0);
        aboveTank.initialFluid = fluidInTank.copyWithAmount(amount);
    }

    private static void splitTank(Level level, BlockPos pos) {
        TankBE removedTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos);
        FluidStack fluidStack = removedTank.getFluidHandler().getFluidInTank(0);
        int tank = removedTank.getBlockPos().getY() - removedTank.getBottomTankPos().getY();
        TankBE topTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, pos.above());
        int topFluidAmount = Math.max(fluidStack.getAmount() - (tank + 1) * BCConfig.tankCapacity, 0);
        topTank.initialFluid = fluidStack.copyWithAmount(topFluidAmount);
        int prevFluidAmount = tank * BCConfig.tankCapacity;
        int fluidAmount = Math.min(fluidStack.getAmount() - prevFluidAmount, BCConfig.tankCapacity);
        BlockPos bottomTankPos = removedTank.getBottomTankPos();
        TankBE bottomTank = BlockUtils.getBE(TankBE.class, (BlockGetter)level, bottomTankPos);
        bottomTank.initialFluid = removedTank.getFluidHandler().getFluidInTank(0).copyWithAmount(fluidStack.getAmount() - topFluidAmount - fluidAmount);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof TankBE) {
            TankBE be = (TankBE)((Object)object);
            if (BCConfig.tankRetainFluids) {
                ItemStack stack = new ItemStack((ItemLike)this);
                FluidStack fluidStack = be.getFluidHandler().getFluidInTank(0);
                int tank = be.getBlockPos().getY() - be.getBottomTankPos().getY();
                int prevFluidAmount = tank * BCConfig.tankCapacity;
                int fluidAmount = Math.min(fluidStack.getAmount() - prevFluidAmount, BCConfig.tankCapacity);
                if (fluidAmount >= 0) {
                    stack.set(BCDataComponents.TANK_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)be.getFluidHandler().getFluidInTank(0).copyWithAmount(fluidAmount)));
                }
                return List.of(stack);
            }
        }
        return super.getDrops(state, params);
    }
}

