/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.content.items.blocks;

import com.portingdeadmods.portingdeadlibs.api.capabilities.DynamicFluidTank;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.content.blockentities.TankBE;
import com.thepigcat.buildcraft.data.BCDataComponents;
import com.thepigcat.buildcraft.registries.BCBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.Nullable;

public class TankBlockItem
extends BlockItem {
    public TankBlockItem(Item.Properties properties) {
        super((Block)BCBlocks.TANK.get(), properties);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof TankBE) {
            TankBE tankBE = (TankBE)be;
            ((DynamicFluidTank)tankBE.getFluidHandler()).setFluid(((SimpleFluidContent)stack.getOrDefault(BCDataComponents.TANK_CONTENT, (Object)SimpleFluidContent.EMPTY)).copy());
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FluidStack stack1;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (BCConfig.tankRetainFluids && !(stack1 = ((SimpleFluidContent)stack.getOrDefault(BCDataComponents.TANK_CONTENT, (Object)SimpleFluidContent.EMPTY)).copy()).isEmpty()) {
            tooltipComponents.add((Component)stack1.getHoverName().copy().append(", %d mb".formatted(stack1.getAmount())).withStyle(ChatFormatting.GRAY));
        }
    }
}

