/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.data.components;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thepigcat.buildcraft.api.capabilties.JumboItemHandler;
import com.thepigcat.buildcraft.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class BigStackContainerContents {
    private static final int NO_SLOT = -1;
    private static final int MAX_SIZE = 256;
    public static final BigStackContainerContents EMPTY = new BigStackContainerContents((NonNullList<JumboItemHandler.BigStack>)NonNullList.create(), 0);
    public static final Codec<BigStackContainerContents> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Slot.CODEC.sizeLimitedListOf(256).fieldOf("items").forGetter(BigStackContainerContents::asSlots), (App)Codec.INT.fieldOf("slot_limit").forGetter(BigStackContainerContents::getSlotLimit)).apply((Applicative)inst, BigStackContainerContents::fromSlots));
    public static final StreamCodec<RegistryFriendlyByteBuf, BigStackContainerContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)JumboItemHandler.BigStack.STREAM_CODEC.apply(ByteBufCodecs.list((int)256)), BigStackContainerContents::getItems, (StreamCodec)ByteBufCodecs.INT, BigStackContainerContents::getSlotLimit, BigStackContainerContents::new);
    private final NonNullList<JumboItemHandler.BigStack> items;
    private final int hashCode;
    private final int slotLimit;

    private BigStackContainerContents(NonNullList<JumboItemHandler.BigStack> items, int slotLimit) {
        if (items.size() > 256) {
            throw new IllegalArgumentException("Got " + items.size() + " items, but maximum is 256");
        }
        this.items = items;
        this.hashCode = ItemUtils.hashStackList(items);
        this.slotLimit = slotLimit;
    }

    private BigStackContainerContents(int size, int slotLimit) {
        this((NonNullList<JumboItemHandler.BigStack>)NonNullList.withSize((int)size, (Object)JumboItemHandler.BigStack.EMPTY), slotLimit);
    }

    private BigStackContainerContents(List<JumboItemHandler.BigStack> items, int slotLimit) {
        this(items.size(), slotLimit);
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)items.get(i));
        }
    }

    public static BigStackContainerContents fromItems(List<JumboItemHandler.BigStack> items, int slotLimit) {
        int i = BigStackContainerContents.findLastNonEmptySlot(items);
        if (i == -1) {
            return EMPTY;
        }
        BigStackContainerContents itemcontainercontents = new BigStackContainerContents(i + 1, slotLimit);
        for (int j = 0; j <= i; ++j) {
            itemcontainercontents.items.set(j, (Object)items.get(j).copy());
        }
        return itemcontainercontents;
    }

    private static BigStackContainerContents fromSlots(List<Slot> slots, int slotLimit) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        BigStackContainerContents itemcontainercontents = new BigStackContainerContents(optionalint.getAsInt() + 1, slotLimit);
        for (Slot itemcontainercontents$slot : slots) {
            itemcontainercontents.items.set(itemcontainercontents$slot.index(), (Object)itemcontainercontents$slot.item());
        }
        return itemcontainercontents;
    }

    private static int findLastNonEmptySlot(List<JumboItemHandler.BigStack> items) {
        for (int i = items.size() - 1; i >= 0; --i) {
            if (items.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            JumboItemHandler.BigStack itemstack = (JumboItemHandler.BigStack)this.items.get(i);
            if (itemstack.isEmpty()) continue;
            list.add(new Slot(i, itemstack));
        }
        return list;
    }

    public int getSlotLimit() {
        return this.slotLimit;
    }

    public void copyInto(NonNullList<JumboItemHandler.BigStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            JumboItemHandler.BigStack itemstack = i < this.items.size() ? (JumboItemHandler.BigStack)this.items.get(i) : JumboItemHandler.BigStack.EMPTY;
            list.set(i, (Object)itemstack.copy());
        }
    }

    public JumboItemHandler.BigStack copyOne() {
        return this.items.isEmpty() ? JumboItemHandler.BigStack.EMPTY : ((JumboItemHandler.BigStack)this.items.get(0)).copy();
    }

    public Stream<JumboItemHandler.BigStack> stream() {
        return this.items.stream().map(JumboItemHandler.BigStack::copy);
    }

    public Stream<JumboItemHandler.BigStack> nonEmptyStream() {
        return this.items.stream().filter(p_331322_ -> !p_331322_.isEmpty()).map(JumboItemHandler.BigStack::copy);
    }

    public Iterable<JumboItemHandler.BigStack> nonEmptyItems() {
        return Iterables.filter(this.items, p_331420_ -> !p_331420_.isEmpty());
    }

    public Iterable<JumboItemHandler.BigStack> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), JumboItemHandler.BigStack::copy);
    }

    public NonNullList<JumboItemHandler.BigStack> getItems() {
        return this.items;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BigStackContainerContents) {
            BigStackContainerContents itemcontainercontents = (BigStackContainerContents)other;
            return ItemUtils.listMatches(this.items, itemcontainercontents.items);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getSlots() {
        return this.items.size();
    }

    public JumboItemHandler.BigStack getStackInSlot(int slot) {
        return ((JumboItemHandler.BigStack)this.items.get(slot)).copy();
    }

    record Slot(int index, JumboItemHandler.BigStack item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(p_331695_ -> p_331695_.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(Slot::index), (App)JumboItemHandler.BigStack.CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)p_331695_, Slot::new));
    }
}

