/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen;

import com.thepigcat.buildcraft.datagen.assets.BCBlockStateProvider;
import com.thepigcat.buildcraft.datagen.assets.BCEnUSLangProvider;
import com.thepigcat.buildcraft.datagen.assets.BCItemModelProvider;
import com.thepigcat.buildcraft.datagen.data.BCBlockLootTableProvider;
import com.thepigcat.buildcraft.datagen.data.BCDatapackRegistryProvider;
import com.thepigcat.buildcraft.datagen.data.BCRecipeProvider;
import com.thepigcat.buildcraft.datagen.data.BCTagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="buildcraft")
public class DataGatherer {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new BCItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BCBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BCEnUSLangProvider(packOutput));
        BCTagProvider.createTagProviders(generator, packOutput, lookupProvider, existingFileHelper, event.includeServer());
        generator.addProvider(event.includeServer(), (DataProvider)new BCDatapackRegistryProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BCRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BCBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

