/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen.assets;

import com.thepigcat.buildcraft.api.blocks.ExtractingPipeBlock;
import com.thepigcat.buildcraft.api.blocks.PipeBlock;
import com.thepigcat.buildcraft.content.blocks.CrateBlock;
import com.thepigcat.buildcraft.content.blocks.TankBlock;
import com.thepigcat.buildcraft.registries.BCBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BCBlockStateProvider
extends BlockStateProvider {
    public BCBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "buildcraft", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.crateBlock((CrateBlock)((Object)BCBlocks.CRATE.get()));
        this.tankBlock((Block)BCBlocks.TANK.get());
        this.engineBlock((Block)BCBlocks.REDSTONE_ENGINE.get());
        this.engineBlock((Block)BCBlocks.STIRLING_ENGINE.get());
        this.engineBlock((Block)BCBlocks.COMBUSTION_ENGINE.get());
        for (Block block : (Registry)BCBlocks.BLOCKS.getRegistry().get()) {
            if (block instanceof ExtractingPipeBlock) {
                this.extractingPipeBlock(block);
                continue;
            }
            if (!(block instanceof PipeBlock)) continue;
            this.pipeBlock(block);
        }
    }

    private void crateBlock(CrateBlock block) {
        this.horizontalBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().cube(this.name((Block)block), this.blockTexture((Block)block, "_top"), this.blockTexture((Block)block, "_top"), this.blockTexture((Block)block, "_front"), this.blockTexture((Block)block, "_side"), this.blockTexture((Block)block, "_side"), this.blockTexture((Block)block, "_side"))).texture("particle", this.blockTexture((Block)block, "_top")));
    }

    private void engineBlock(Block block) {
        ResourceLocation blockLoc = this.key(block);
        String path = "block/engine/" + blockLoc.getPath();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("block/engine_base"))).texture("top", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)(path + "_top")))).texture("side", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)(path + "_side")));
        this.facingBlock(block, (ModelFile)model);
    }

    public void facingBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationX(90).rotationY(270).addModel();
    }

    private void tankBlock(Block block) {
        ResourceLocation blockTexture = this.blockTexture(block);
        ResourceLocation topTexture = this.suffix(blockTexture, "_top");
        ResourceLocation topJoinedTexture = this.suffix(blockTexture, "_top_joined");
        ResourceLocation sideTexture = this.suffix(blockTexture, "_side");
        ResourceLocation sideJoinedTexture = this.suffix(blockTexture, "_side_joined");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)TankBlock.TOP_JOINED, (Comparable)Boolean.valueOf(true)).with((Property)TankBlock.BOTTOM_JOINED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.tankModel(this.suffix(blockTexture, "_top_and_bottom_joined"), topJoinedTexture, sideJoinedTexture, topJoinedTexture)).addModel()).partialState().with((Property)TankBlock.TOP_JOINED, (Comparable)Boolean.valueOf(true)).with((Property)TankBlock.BOTTOM_JOINED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.tankModel(this.suffix(blockTexture, "_top_joined"), topJoinedTexture, sideTexture, topTexture)).addModel()).partialState().with((Property)TankBlock.TOP_JOINED, (Comparable)Boolean.valueOf(false)).with((Property)TankBlock.BOTTOM_JOINED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.tankModel(this.suffix(blockTexture, "_bottom_joined"), topTexture, sideJoinedTexture, topJoinedTexture)).addModel()).partialState().with((Property)TankBlock.TOP_JOINED, (Comparable)Boolean.valueOf(false)).with((Property)TankBlock.BOTTOM_JOINED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.tankModel(blockTexture, topTexture, sideTexture, topTexture)).addModel();
    }

    private void pillarBlock(Block block) {
        this.pillarBlock(block, this.blockTexture(block));
    }

    private void pillarBlock(Block block, ResourceLocation base) {
        ResourceLocation side = this.suffix(base, "_side");
        ResourceLocation top = this.suffix(base, "_top");
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cube(this.name(block), top, top, side, side, side, side)).texture("particle", side));
    }

    private void pipeBlock(Block block) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)block);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        this.pipeConnection(builder, loc, Direction.DOWN, 0, 0);
        this.pipeConnection(builder, loc, Direction.UP, 180, 0);
        this.pipeConnection(builder, loc, Direction.NORTH, 90, 180);
        this.pipeConnection(builder, loc, Direction.EAST, 90, 270);
        this.pipeConnection(builder, loc, Direction.SOUTH, 90, 0);
        this.pipeConnection(builder, loc, Direction.WEST, 90, 90);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeBaseModel(loc)).addModel()).end();
    }

    private void pipeConnection(MultiPartBlockStateBuilder builder, ResourceLocation loc, Direction direction, int x, int y) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeConnectionModel(loc)).rotationX(x).rotationY(y).addModel()).condition(PipeBlock.CONNECTION[direction.get3DDataValue()], (Comparable[])new PipeBlock.PipeState[]{PipeBlock.PipeState.CONNECTED}).end();
    }

    private void extractingPipeBlock(Block block) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)block);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        this.extractingPipeConnection(builder, loc, Direction.DOWN, 0, 0);
        this.extractingPipeConnection(builder, loc, Direction.UP, 180, 0);
        this.extractingPipeConnection(builder, loc, Direction.NORTH, 90, 180);
        this.extractingPipeConnection(builder, loc, Direction.EAST, 90, 270);
        this.extractingPipeConnection(builder, loc, Direction.SOUTH, 90, 0);
        this.extractingPipeConnection(builder, loc, Direction.WEST, 90, 90);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeBaseModel(loc)).addModel()).end();
    }

    private void extractingPipeConnection(MultiPartBlockStateBuilder builder, ResourceLocation loc, Direction direction, int x, int y) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeConnectionModel(loc)).rotationX(x).rotationY(y).addModel()).condition(PipeBlock.CONNECTION[direction.get3DDataValue()], (Comparable[])new PipeBlock.PipeState[]{PipeBlock.PipeState.CONNECTED}).end().part().modelFile(this.pipeExtractingModel(loc)).rotationX(x).rotationY(y).addModel()).condition(PipeBlock.CONNECTION[direction.get3DDataValue()], (Comparable[])new PipeBlock.PipeState[]{PipeBlock.PipeState.EXTRACTING}).end();
    }

    private ModelFile pipeBaseModel(ResourceLocation blockLoc) {
        return ((BlockModelBuilder)this.models().withExistingParent(blockLoc.getPath() + "_base", this.modLoc("block/pipe_base"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)("block/" + blockLoc.getPath())));
    }

    private ModelFile tankModel(ResourceLocation baseLoc, ResourceLocation topLoc, ResourceLocation sideLoc, ResourceLocation bottomLoc) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseLoc.getPath(), this.modLoc("block/tank_base"))).texture("top", ResourceLocation.fromNamespaceAndPath((String)topLoc.getNamespace(), (String)topLoc.getPath()))).texture("bottom", ResourceLocation.fromNamespaceAndPath((String)bottomLoc.getNamespace(), (String)bottomLoc.getPath()))).texture("side", ResourceLocation.fromNamespaceAndPath((String)sideLoc.getNamespace(), (String)sideLoc.getPath()));
    }

    private ModelFile pipeConnectionModel(ResourceLocation blockLoc) {
        return ((BlockModelBuilder)this.models().withExistingParent(blockLoc.getPath() + "_connection", this.modLoc("block/pipe_connection"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)("block/" + blockLoc.getPath())));
    }

    private ModelFile pipeExtractingModel(ResourceLocation blockLoc) {
        return ((BlockModelBuilder)this.models().withExistingParent(blockLoc.getPath() + "_connection_extracting", this.modLoc("block/pipe_connection"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)("block/" + blockLoc.getPath() + "_extracting")));
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    public ResourceLocation blockTexture(Block block, String suffix) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + suffix));
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath()));
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return rl.withSuffix(suffix);
    }

    private ResourceLocation prefix(String prefix, ResourceLocation rl) {
        return rl.withPrefix(prefix);
    }

    private ResourceLocation inDir(ResourceLocation rl, String directory) {
        StringBuilder path = new StringBuilder();
        String[] dirs = rl.getPath().split("/");
        for (int i = 0; i < dirs.length; ++i) {
            if (i == dirs.length - 1) {
                path.append(directory).append("/");
            }
            path.append(dirs[i]).append(i != dirs.length - 1 ? "/" : "");
        }
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)path.toString());
    }
}

