/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen.assets;

import com.portingdeadmods.portingdeadlibs.api.config.PDLConfigHelper;
import com.thepigcat.buildcraft.BCConfig;
import com.thepigcat.buildcraft.api.blockentities.RedstoneBlockEntity;
import com.thepigcat.buildcraft.registries.BCBlocks;
import com.thepigcat.buildcraft.registries.BCFluids;
import com.thepigcat.buildcraft.registries.BCItems;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BCEnUSLangProvider
extends LanguageProvider {
    public BCEnUSLangProvider(PackOutput output) {
        super(output, "buildcraft", "en_us");
    }

    protected void addTranslations() {
        PDLConfigHelper.generateConfigNames(BCConfig.class, (String)"buildcraft", (arg_0, arg_1) -> ((BCEnUSLangProvider)this).add(arg_0, arg_1));
        this.addItem((Supplier)BCItems.WRENCH, "Wrench");
        this.addItem((Supplier)BCItems.WOODEN_GEAR, "Wooden Gear");
        this.addItem((Supplier)BCItems.STONE_GEAR, "Stone Gear");
        this.addItem((Supplier)BCItems.IRON_GEAR, "Iron Gear");
        this.addItem((Supplier)BCItems.GOLD_GEAR, "Gold Gear");
        this.addItem((Supplier)BCItems.DIAMOND_GEAR, "Diamond Gear");
        this.addItem((Supplier)BCFluids.OIL.getDeferredBucket(), "Oil Bucket");
        this.addBlock((Supplier)BCBlocks.CRATE, "Crate");
        this.addBlock((Supplier)BCBlocks.TANK, "Tank");
        this.addBlock(BCFluids.OIL.block, "Oil");
        this.addBlock((Supplier)BCBlocks.REDSTONE_ENGINE, "Redstone Engine");
        this.addBlock((Supplier)BCBlocks.STIRLING_ENGINE, "Stirling Engine");
        this.addBlock((Supplier)BCBlocks.COMBUSTION_ENGINE, "Combustion Engine");
        this.addFluidType(BCFluids.OIL.fluidType, "Oil");
        this.add("itemGroup.buildcraft.bc_tab", "Buildcraft");
        this.addRedstoneSignalType(RedstoneBlockEntity.RedstoneSignalType.IGNORED, "Ignored");
        this.addRedstoneSignalType(RedstoneBlockEntity.RedstoneSignalType.LOW_SIGNAL, "Low Signal");
        this.addRedstoneSignalType(RedstoneBlockEntity.RedstoneSignalType.HIGH_SIGNAL, "High Signal");
    }

    private void addRedstoneSignalType(RedstoneBlockEntity.RedstoneSignalType signalType, String translation) {
        this.add("redstone_signal_type.buildcraft." + signalType.getSerializedName(), translation);
    }

    private void addFluidType(Supplier<FluidType> fluidTypeSupplier, String translation) {
        ResourceLocation location = NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluidTypeSupplier.get());
        String fluidTypeName = location.getPath();
        String modid = location.getNamespace();
        this.add("fluid_type." + modid + "." + fluidTypeName, translation);
    }
}

