/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen.assets;

import com.thepigcat.buildcraft.api.blocks.PipeBlock;
import com.thepigcat.buildcraft.registries.BCBlocks;
import com.thepigcat.buildcraft.registries.BCFluids;
import com.thepigcat.buildcraft.registries.BCItems;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class BCItemModelProvider
extends ItemModelProvider {
    private static final Set<Block> DEFAULT_MODEL_BLACKLIST = Set.of((Block)BCBlocks.TANK.get(), (Block)BCBlocks.CRATE.get(), (Block)BCBlocks.REDSTONE_ENGINE.get(), (Block)BCBlocks.STIRLING_ENGINE.get(), (Block)BCBlocks.COMBUSTION_ENGINE.get());

    public BCItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "buildcraft", existingFileHelper);
    }

    protected void registerModels() {
        this.handHeldItem((Item)BCItems.WRENCH.get());
        this.basicItem((Item)BCItems.WOODEN_GEAR.get());
        this.basicItem((Item)BCItems.STONE_GEAR.get());
        this.basicItem((Item)BCItems.IRON_GEAR.get());
        this.basicItem((Item)BCItems.GOLD_GEAR.get());
        this.basicItem((Item)BCItems.DIAMOND_GEAR.get());
        this.basicItem(BCFluids.OIL.getBucket());
        this.blockItems();
    }

    private void blockItems() {
        for (DeferredItem<BlockItem> blockItem : BCItems.BLOCK_ITEMS) {
            if (DEFAULT_MODEL_BLACKLIST.contains(((BlockItem)blockItem.get()).getBlock())) continue;
            if (((BlockItem)blockItem.get()).getBlock() instanceof PipeBlock) {
                this.pipeItemModel((Item)blockItem.get());
                continue;
            }
            this.parentItemBlock((Item)blockItem.get());
        }
    }

    public void bucketItem(Fluid fluid) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(fluid.getBucket().asItem()), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket_drip"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid);
    }

    public String name(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public ItemModelBuilder parentItemBlock(Item item, ResourceLocation loc) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(loc));
    }

    public ItemModelBuilder parentItemBlock(Item item) {
        return this.parentItemBlock(item, "");
    }

    public ItemModelBuilder parentItemBlock(Item item, String suffix) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + suffix))));
    }

    public void pipeItemModel(Item item) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/pipe_inventory")))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath())));
    }

    public ItemModelBuilder handHeldItem(Item item) {
        return this.handHeldItem(item, "");
    }

    public ItemModelBuilder handHeldItem(Item item, String suffix) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(location) + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath() + suffix)));
    }
}

