/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen.data;

import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.registries.BCBlocks;
import com.thepigcat.buildcraft.registries.BCItems;
import com.thepigcat.buildcraft.tags.BCTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class BCRecipeProvider
extends RecipeProvider {
    public BCRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, BCItems.WRENCH).pattern("I I").pattern(" G ").pattern(" I ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), BCTags.Items.STONE_GEAR).unlockedBy("has_stone_gear", BCRecipeProvider.has(BCTags.Items.STONE_GEAR)).save(recipeOutput);
        this.gearRecipe(recipeOutput, (TagKey<Item>)ItemTags.PLANKS, null, (ItemLike)BCItems.WOODEN_GEAR);
        this.gearRecipe(recipeOutput, (TagKey<Item>)Tags.Items.COBBLESTONES, BCTags.Items.WOODEN_GEAR, (ItemLike)BCItems.STONE_GEAR);
        this.gearRecipe(recipeOutput, (TagKey<Item>)Tags.Items.INGOTS_IRON, BCTags.Items.STONE_GEAR, (ItemLike)BCItems.IRON_GEAR);
        this.gearRecipe(recipeOutput, (TagKey<Item>)Tags.Items.INGOTS_GOLD, BCTags.Items.IRON_GEAR, (ItemLike)BCItems.GOLD_GEAR);
        this.gearRecipe(recipeOutput, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, BCTags.Items.GOLD_GEAR, (ItemLike)BCItems.DIAMOND_GEAR);
        this.engineRecipe(recipeOutput, (TagKey<Item>)ItemTags.PLANKS, BCTags.Items.WOODEN_GEAR, (ItemLike)BCBlocks.REDSTONE_ENGINE);
        this.engineRecipe(recipeOutput, (TagKey<Item>)Tags.Items.COBBLESTONES, BCTags.Items.STONE_GEAR, (ItemLike)BCBlocks.STIRLING_ENGINE);
        this.engineRecipe(recipeOutput, (TagKey<Item>)Tags.Items.INGOTS_IRON, BCTags.Items.IRON_GEAR, (ItemLike)BCBlocks.COMBUSTION_ENGINE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, BCBlocks.CRATE).pattern("LSL").pattern("L L").pattern("LSL").define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).unlockedBy("has_log", BCRecipeProvider.has((TagKey<Item>)ItemTags.LOGS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, BCBlocks.TANK).pattern("GGG").pattern("G G").pattern("GGG").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_glass", BCRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS_BLOCKS)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, BCBlocks.TANK).requires(BCBlocks.TANK).unlockedBy("has_tank", BCRecipeProvider.has(BCBlocks.TANK)).save(recipeOutput, BuildcraftLegacy.rl("tank_reset"));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return RecipeProvider.has(tag);
    }

    private void engineRecipe(RecipeOutput recipeOutput, TagKey<Item> material, TagKey<Item> gear, ItemLike result) {
        String path = material.location().getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("MMM").pattern(" L ").pattern("GPG").define(Character.valueOf('M'), material).define(Character.valueOf('L'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('G'), gear).define(Character.valueOf('P'), (ItemLike)Items.PISTON).unlockedBy("has_" + path, BCRecipeProvider.has(material)).save(recipeOutput);
    }

    private void pipeRecipe(RecipeOutput recipeOutput, TagKey<Item> material, ItemLike result) {
        String path = material.location().getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).pattern("MGM").define(Character.valueOf('M'), material).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_" + path, BCRecipeProvider.has(material)).save(recipeOutput);
    }

    private void gearRecipe(RecipeOutput recipeOutput, TagKey<Item> material, @Nullable TagKey<Item> previous, ItemLike result) {
        String path = material.location().getPath();
        if (previous != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern(" M ").pattern("MPM").pattern(" M ").define(Character.valueOf('M'), material).define(Character.valueOf('P'), previous).unlockedBy("has_" + path, BCRecipeProvider.has(material)).save(recipeOutput);
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern(" M ").pattern("M M").pattern(" M ").define(Character.valueOf('M'), material).unlockedBy("has_" + path, BCRecipeProvider.has(material)).save(recipeOutput);
        }
    }
}

