/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.datagen.data;

import com.thepigcat.buildcraft.registries.BCBlocks;
import com.thepigcat.buildcraft.registries.BCFluids;
import com.thepigcat.buildcraft.registries.BCItems;
import com.thepigcat.buildcraft.tags.BCTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BCTagProvider {
    public static void createTagProviders(DataGenerator generator, PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper, boolean isServer) {
        Block provider = new Block(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(isServer, (DataProvider)provider);
        generator.addProvider(isServer, (DataProvider)new Item(packOutput, lookupProvider, provider.contentsGetter()));
        generator.addProvider(isServer, (DataProvider)new Fluid(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(isServer, (DataProvider)new Biome(packOutput, lookupProvider, existingFileHelper));
    }

    public static class Block
    extends BlockTagsProvider {
        public Block(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "buildcraft", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)((net.minecraft.world.level.block.Block)BCBlocks.CRATE.get()));
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((net.minecraft.world.level.block.Block)BCBlocks.TANK.get()));
        }
    }

    public static class Item
    extends ItemTagsProvider {
        public Item(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<net.minecraft.world.level.block.Block>> blockTags) {
            super(output, lookupProvider, blockTags);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BCTags.Items.GEARS).add((Object[])new net.minecraft.world.item.Item[]{(net.minecraft.world.item.Item)BCItems.WOODEN_GEAR.get(), (net.minecraft.world.item.Item)BCItems.STONE_GEAR.get(), (net.minecraft.world.item.Item)BCItems.IRON_GEAR.get(), (net.minecraft.world.item.Item)BCItems.GOLD_GEAR.get(), (net.minecraft.world.item.Item)BCItems.DIAMOND_GEAR.get()});
            this.tag(BCTags.Items.WOODEN_GEAR).add((Object)((net.minecraft.world.item.Item)BCItems.WOODEN_GEAR.get()));
            this.tag(BCTags.Items.STONE_GEAR).add((Object)((net.minecraft.world.item.Item)BCItems.STONE_GEAR.get()));
            this.tag(BCTags.Items.IRON_GEAR).add((Object)((net.minecraft.world.item.Item)BCItems.IRON_GEAR.get()));
            this.tag(BCTags.Items.GOLD_GEAR).add((Object)((net.minecraft.world.item.Item)BCItems.GOLD_GEAR.get()));
            this.tag(BCTags.Items.DIAMOND_GEAR).add((Object)((net.minecraft.world.item.Item)BCItems.DIAMOND_GEAR.get()));
        }
    }

    public static class Fluid
    extends FluidTagsProvider {
        public Fluid(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "buildcraft", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BCTags.Fluids.OIL).add((Object[])new net.minecraft.world.level.material.Fluid[]{BCFluids.OIL.getStillFluid(), BCFluids.OIL.getStillFluid()});
            this.tag(BCTags.Fluids.COMBUSTION_FUEL).addTag(BCTags.Fluids.OIL);
        }
    }

    public static class Biome
    extends BiomeTagsProvider {
        public Biome(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "buildcraft", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BCTags.Biomes.GENERATE_OIL).addTags(new TagKey[]{Tags.Biomes.IS_PLAINS, Tags.Biomes.IS_DESERT, Tags.Biomes.IS_BADLANDS, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_SAVANNA});
        }
    }
}

