/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.mixins;

import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.PipesRegistry;
import com.thepigcat.buildcraft.api.pipes.Pipe;
import com.thepigcat.buildcraft.api.pipes.PipeType;
import com.thepigcat.buildcraft.util.PipeRegistrationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Mutable
    @Shadow
    @Final
    private Map<ResourceLocation, BlockModel> modelResources;
    @Shadow
    @Final
    public static FileToIdConverter MODEL_LISTER;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V")})
    private void buildcraft$init(BlockColors blockColors, ProfilerFiller profilerFiller, Map<ResourceLocation, BlockModel> modelResources, Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> blockStateResources, CallbackInfo ci) {
        Block block;
        this.modelResources = new HashMap<ResourceLocation, BlockModel>(this.modelResources);
        for (Map.Entry<String, Pipe> entry : PipesRegistry.PIPES.entrySet()) {
            block = (Block)BuiltInRegistries.BLOCK.get(BuildcraftLegacy.rl(entry.getKey()));
            ResourceLocation blockId = block.builtInRegistryHolder().key().location();
            ResourceLocation location = blockId.withPath("block/" + blockId.getPath());
            PipeType<?, ?> type = PipeRegistrationHelper.PIPE_TYPES.get(entry.getValue().type());
            for (String s : type.models()) {
                ResourceLocation modelLocation = location.withSuffix("_" + s);
                ResourceLocation modelLocationFile = MODEL_LISTER.idToFile(modelLocation);
                BlockModel blockModel = BlockModel.fromString((String)type.defaultBlockModel().apply(entry.getValue(), modelLocation));
                this.modelResources.put(modelLocationFile, blockModel);
            }
        }
        for (Map.Entry<String, Pipe> entry : PipesRegistry.PIPES.entrySet()) {
            block = (Block)BuiltInRegistries.BLOCK.get(BuildcraftLegacy.rl(entry.getKey()));
            PipeType<?, ?> type = PipeRegistrationHelper.PIPE_TYPES.get(entry.getValue().type());
            ResourceLocation itemId = block.builtInRegistryHolder().key().location();
            ResourceLocation location = itemId.withPath("item/" + itemId.getPath());
            ResourceLocation locationFile = MODEL_LISTER.idToFile(location);
            BlockModel itemModel = BlockModel.fromString((String)type.defaultItemModel().apply(entry.getValue(), itemId.getPath()));
            this.modelResources.put(locationFile, itemModel);
        }
    }
}

