/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.mixins;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.PipesRegistry;
import com.thepigcat.buildcraft.api.pipes.Pipe;
import com.thepigcat.buildcraft.datagen.data.BCRecipeProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Shadow
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    @Shadow
    private Map<ResourceLocation, RecipeHolder<?>> byName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="TAIL")})
    private void buildcraft$apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        this.byType = HashMultimap.create(this.byType);
        this.byName = new HashMap(this.byName);
        RecipeOutput output = new RecipeOutput(){

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }

            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                RecipeHolder holder = new RecipeHolder(resourceLocation, recipe);
                RecipeManagerMixin.this.byType.put((Object)RecipeType.CRAFTING, (Object)holder);
                RecipeManagerMixin.this.byName.put(resourceLocation, holder);
            }
        };
        Iterator<Map.Entry<String, Pipe>> iterator = PipesRegistry.PIPES.entrySet().iterator();
        while (true) {
            TagKey tagKey;
            if (!iterator.hasNext()) {
                this.byType = ImmutableMultimap.copyOf(this.byType);
                this.byName = Collections.unmodifiableMap(this.byName);
                return;
            }
            Map.Entry<String, Pipe> entry = iterator.next();
            if (entry.getValue().customRecipe()) continue;
            ResourceLocation rl = BuildcraftLegacy.rl(entry.getKey());
            ShapedRecipeBuilder shapedRecipeBuilder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(rl)), (int)8).pattern("IGI").define(Character.valueOf('I'), entry.getValue().ingredient()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS);
            Ingredient.Value value = entry.getValue().ingredient().getValues()[0];
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    TagKey tagKey2;
                    TagKey tag;
                    tagKey = tag = (tagKey2 = tagValue.tag());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            } else {
                tagKey = Tags.Items.GLASS_BLOCKS_COLORLESS;
            }
            shapedRecipeBuilder.unlockedBy("has_item", BCRecipeProvider.has((TagKey<Item>)tagKey)).save(output);
        }
    }
}

