/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.networking;

import com.portingdeadmods.portingdeadlibs.utils.codec.CodecUtils;
import com.thepigcat.buildcraft.BuildcraftLegacy;
import com.thepigcat.buildcraft.api.blockentities.RedstoneBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RedstoneSignalTypeSyncPayload(BlockPos pos, RedstoneBlockEntity.RedstoneSignalType signalType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RedstoneSignalTypeSyncPayload> TYPE = new CustomPacketPayload.Type(BuildcraftLegacy.rl("redstone_signal_type_sync"));
    public static final StreamCodec<ByteBuf, RedstoneSignalTypeSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RedstoneSignalTypeSyncPayload::pos, (StreamCodec)CodecUtils.enumStreamCodec(RedstoneBlockEntity.RedstoneSignalType.class), RedstoneSignalTypeSyncPayload::signalType, RedstoneSignalTypeSyncPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity = context.player().level().getBlockEntity(this.pos);
            if (blockEntity instanceof RedstoneBlockEntity) {
                RedstoneBlockEntity redstoneBlockEntity = (RedstoneBlockEntity)blockEntity;
                redstoneBlockEntity.setRedstoneSignalType(this.signalType);
            }
        }).exceptionally(err -> {
            BuildcraftLegacy.LOGGER.error("Failed to handle RedstoneSignalTypeSync payload", err);
            return null;
        });
    }
}

