/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.networking;

import com.thepigcat.buildcraft.content.blockentities.ItemPipeBE;
import com.thepigcat.buildcraft.util.BlockUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncPipeDirectionPayload(BlockPos pos, Optional<Direction> from, Optional<Direction> to) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPipeDirectionPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"buildcraft", (String)"sync_pipe_dir"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPipeDirectionPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncPipeDirectionPayload::pos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), SyncPipeDirectionPayload::from, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), SyncPipeDirectionPayload::to, SyncPipeDirectionPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncPipeDirectionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemPipeBE be = BlockUtils.getBE(ItemPipeBE.class, (BlockGetter)context.player().level(), payload.pos());
            if (be != null) {
                be.setFrom(payload.from.orElse(null));
                be.setTo(payload.to.orElse(null));
            }
        });
    }
}

