/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.registries;

import com.thepigcat.buildcraft.content.blocks.CombustionEngineBlock;
import com.thepigcat.buildcraft.content.blocks.CrateBlock;
import com.thepigcat.buildcraft.content.blocks.RedstoneEngineBlock;
import com.thepigcat.buildcraft.content.blocks.StirlingEngineBlock;
import com.thepigcat.buildcraft.content.blocks.TankBlock;
import com.thepigcat.buildcraft.content.items.blocks.CrateBlockItem;
import com.thepigcat.buildcraft.content.items.blocks.TankBlockItem;
import com.thepigcat.buildcraft.data.BCDataComponents;
import com.thepigcat.buildcraft.data.components.BigStackContainerContents;
import com.thepigcat.buildcraft.registries.BCItems;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class BCBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"buildcraft");
    public static final DeferredBlock<RedstoneEngineBlock> REDSTONE_ENGINE = BCBlocks.registerBlockAndItem("redstone_engine", RedstoneEngineBlock::new, BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD));
    public static final DeferredBlock<StirlingEngineBlock> STIRLING_ENGINE = BCBlocks.registerBlockAndItem("stirling_engine", StirlingEngineBlock::new, BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.STONE).mapColor(MapColor.STONE).requiresCorrectToolForDrops());
    public static final DeferredBlock<CombustionEngineBlock> COMBUSTION_ENGINE = BCBlocks.registerBlockAndItem("combustion_engine", CombustionEngineBlock::new, BlockBehaviour.Properties.of().strength(5.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlock<CrateBlock> CRATE = BCBlocks.registerBlockAndItem("crate", CrateBlock::new, BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD), () -> new CrateBlockItem(new Item.Properties().component(BCDataComponents.CRATE_CONTENT, (Object)BigStackContainerContents.EMPTY)));
    public static final DeferredBlock<TankBlock> TANK = BCBlocks.registerBlockAndItem("tank", TankBlock::new, BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS), () -> new TankBlockItem(new Item.Properties().component(BCDataComponents.TANK_CONTENT, (Object)SimpleFluidContent.EMPTY)));

    public static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> blockConstructor, BlockBehaviour.Properties props) {
        DeferredBlock toReturn = BLOCKS.registerBlock(name, blockConstructor, props);
        DeferredItem item = BCItems.ITEMS.registerSimpleBlockItem((Holder)toReturn);
        BCItems.BLOCK_ITEMS.add((DeferredItem<BlockItem>)item);
        BCItems.TAB_ITEMS.add(item);
        return toReturn;
    }

    public static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> blockConstructor, BlockBehaviour.Properties props, Supplier<BlockItem> blockItemSupplier) {
        DeferredBlock toReturn = BLOCKS.registerBlock(name, blockConstructor, props);
        DeferredItem item = BCItems.ITEMS.register(name, blockItemSupplier);
        BCItems.BLOCK_ITEMS.add((DeferredItem<BlockItem>)item);
        BCItems.TAB_ITEMS.add(item);
        return toReturn;
    }
}

