/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class CapabilityUtils {
    @Nullable
    public static <T, C> T blockEntityCapability(BlockCapability<T, C> cap, BlockEntity blockEntity) {
        return (T)blockEntity.getLevel().getCapability(cap, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, null);
    }

    @Nullable
    public static <T, C> T blockEntityCapability(BlockCapability<T, C> cap, BlockEntity blockEntity, C ctx) {
        return (T)blockEntity.getLevel().getCapability(cap, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, ctx);
    }

    @Nullable
    public static IEnergyStorage energyStorageCapability(BlockEntity blockEntity) {
        return (IEnergyStorage)CapabilityUtils.blockEntityCapability(Capabilities.EnergyStorage.BLOCK, blockEntity);
    }

    @Nullable
    public static IItemHandler itemHandlerCapability(BlockEntity blockEntity) {
        return (IItemHandler)CapabilityUtils.blockEntityCapability(Capabilities.ItemHandler.BLOCK, blockEntity);
    }

    @Nullable
    public static IItemHandler itemHandlerCapability(BlockEntity blockEntity, Direction direction) {
        return (IItemHandler)CapabilityUtils.blockEntityCapability(Capabilities.ItemHandler.BLOCK, blockEntity, direction);
    }

    @Nullable
    public static IFluidHandler fluidHandlerCapability(BlockEntity blockEntity) {
        return (IFluidHandler)CapabilityUtils.blockEntityCapability(Capabilities.FluidHandler.BLOCK, blockEntity);
    }
}

