/*
 * Decompiled with CFR 0.152.
 */
package com.thepigcat.buildcraft.util;

import com.thepigcat.buildcraft.PipesRegistry;
import com.thepigcat.buildcraft.api.pipes.Pipe;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public final class ModelUtils {
    public static final BiFunction<Pipe, ResourceLocation, String> DEFAULT_BLOCK_MODEL_DEFINITION = (pipe, pipeId) -> {
        String pipeIdLiteral = pipeId.withPrefix("block/").toString();
        return "{\"multipart\":[{\"apply\":{\"model\":\"%s_connection\"},\"when\":{\"down\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_connection\",\"x\":180},\"when\":{\"up\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_connection\",\"x\":90,\"y\":180},\"when\":{\"north\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_connection\",\"x\":90,\"y\":270},\"when\":{\"east\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_connection\",\"x\":90},\"when\":{\"south\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_connection\",\"x\":90,\"y\":90},\"when\":{\"west\":\"connected\"}},\n{\"apply\":{\"model\":\"%s_base\"}}]}".formatted(pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral);
    };
    public static final BiFunction<Pipe, ResourceLocation, String> EXTRACTING_BLOCK_MODEL_DEFINITION = (pipe, pipeId) -> {
        String pipeIdLiteral = pipeId.withPrefix("block/").toString();
        return "{\n  \"multipart\": [\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\"\n      },\n      \"when\": {\n        \"down\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\"\n      },\n      \"when\": {\n        \"down\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\",\n        \"x\": 180\n      },\n      \"when\": {\n        \"up\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\",\n        \"x\": 180\n      },\n      \"when\": {\n        \"up\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\",\n        \"x\": 90,\n        \"y\": 180\n      },\n      \"when\": {\n        \"north\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\",\n        \"x\": 90,\n        \"y\": 180\n      },\n      \"when\": {\n        \"north\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\",\n        \"x\": 90,\n        \"y\": 270\n      },\n      \"when\": {\n        \"east\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\",\n        \"x\": 90,\n        \"y\": 270\n      },\n      \"when\": {\n        \"east\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\",\n        \"x\": 90\n      },\n      \"when\": {\n        \"south\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\",\n        \"x\": 90\n      },\n      \"when\": {\n        \"south\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection\",\n        \"x\": 90,\n        \"y\": 90\n      },\n      \"when\": {\n        \"west\": \"connected\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_connection_extracting\",\n        \"x\": 90,\n        \"y\": 90\n      },\n      \"when\": {\n        \"west\": \"extracting\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"%s_base\"\n      }\n    }\n  ]\n}".formatted(pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral, pipeIdLiteral);
    };
    public static final BiFunction<Pipe, String, String> DEFAULT_ITEM_MODEL_FILE = (pipe, pipeId) -> {
        List<ResourceLocation> textures = PipesRegistry.PIPES.get(pipeId).textures();
        return "{\n  \"parent\": \"buildcraft:item/pipe_inventory\",\n  \"textures\": {\n    \"texture\": \"%s\"\n  }\n}".formatted(!textures.isEmpty() ? textures.getFirst().toString() : "missing");
    };
    public static final BiFunction<Pipe, ResourceLocation, String> DEFAULT_BLOCK_MODEL_FILE = (pipe, texture) -> {
        int textureIndex = 0;
        String parent = "";
        if (texture.getPath().endsWith("_connection")) {
            parent = "buildcraft:block/pipe_connection";
        } else if (texture.getPath().endsWith("_base")) {
            parent = "buildcraft:block/pipe_base";
        } else if (texture.getPath().endsWith("_connection_extracting")) {
            textureIndex = 1;
            parent = "buildcraft:block/pipe_connection";
        }
        return "{\n  \"parent\": \"%s\",\n  \"textures\": {\n    \"texture\": \"%s\"\n  }\n}".formatted(parent, pipe.textures().size() > textureIndex ? pipe.textures().get(textureIndex) : "missing");
    };

    public static ResourceLocation modelLocationToBlockId(ResourceLocation modelLocation) {
        String[] split = modelLocation.getPath().split("/");
        String name = split[split.length - 1];
        return ResourceLocation.fromNamespaceAndPath((String)modelLocation.getNamespace(), (String)name);
    }

    public static enum ParentType implements StringRepresentable
    {
        BASE("base"),
        CONNECTION("connection");

        private final String parentType;

        private ParentType(String parentType) {
            this.parentType = parentType;
        }

        @NotNull
        public String getSerializedName() {
            return this.parentType;
        }
    }
}

