/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.config;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mods.octarinecore.client.gui.NonVerboseArrayEntry;
import mods.octarinecore.client.resource.Utils;
import mods.octarinecore.common.config.ConfigPropertyBase;
import mods.octarinecore.metaprog.Reflection;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.WorldEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0013J(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020'H\u0016J\u0006\u0010.\u001a\u00020'J.\u00105\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000307\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000307062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001b\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0014\u0010/\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u0018038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u000e\u00a8\u0006;"}, d2={"Lmods/betterfoliage/client/config/BlockMatcher;", "Lmods/octarinecore/common/config/ConfigPropertyBase;", "domain", "", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDomain", "()Ljava/lang/String;", "getPath", "blackList", "", "Ljava/lang/Class;", "getBlackList", "()Ljava/util/List;", "whiteList", "getWhiteList", "blockIDs", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getBlockIDs", "()Ljava/util/HashSet;", "blacklistProperty", "Lnet/minecraftforge/common/config/Property;", "getBlacklistProperty", "()Lnet/minecraftforge/common/config/Property;", "setBlacklistProperty", "(Lnet/minecraftforge/common/config/Property;)V", "whitelistProperty", "getWhitelistProperty", "setWhitelistProperty", "matchesClass", "", "block", "Lnet/minecraft/block/Block;", "matchesID", "blockId", "attach", "", "target", "Lnet/minecraftforge/common/config/Configuration;", "langPrefix", "categoryName", "propertyName", "read", "updateIDs", "hasChanged", "getHasChanged", "()Z", "guiProperties", "", "getGuiProperties", "readDefaults", "Lkotlin/Pair;", "", "onWorldLoad", "event", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nBlockMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockMatcher.kt\nmods/betterfoliage/client/config/BlockMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n1863#2,2:131\n1863#2,2:133\n1863#2,2:135\n1863#2:137\n1864#2:142\n1863#2,2:143\n1557#2:145\n1628#2,3:146\n774#2:149\n865#2,2:150\n1863#2,2:152\n11158#3:138\n11493#3,3:139\n37#4:154\n36#4,3:155\n*S KotlinDebug\n*F\n+ 1 BlockMatcher.kt\nmods/betterfoliage/client/config/BlockMatcher\n*L\n34#1:131,2\n35#1:133,2\n51#1:135,2\n59#1:137\n59#1:142\n68#1:143,2\n84#1:145\n84#1:146,3\n85#1:149\n85#1:150,2\n86#1:152,2\n61#1:138\n61#1:139,3\n93#1:154\n93#1:155,3\n*E\n"})
public final class BlockMatcher
extends ConfigPropertyBase {
    @NotNull
    private final String domain;
    @NotNull
    private final String path;
    @NotNull
    private final List<Class<?>> blackList;
    @NotNull
    private final List<Class<?>> whiteList;
    @NotNull
    private final HashSet<Integer> blockIDs;
    @Nullable
    private Property blacklistProperty;
    @Nullable
    private Property whitelistProperty;

    public BlockMatcher(@NotNull String domain, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.domain = domain;
        this.path = path;
        this.blackList = new ArrayList();
        this.whiteList = new ArrayList();
        this.blockIDs = new HashSet();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final List<Class<?>> getBlackList() {
        return this.blackList;
    }

    @NotNull
    public final List<Class<?>> getWhiteList() {
        return this.whiteList;
    }

    @NotNull
    public final HashSet<Integer> getBlockIDs() {
        return this.blockIDs;
    }

    @Nullable
    public final Property getBlacklistProperty() {
        return this.blacklistProperty;
    }

    public final void setBlacklistProperty(@Nullable Property property) {
        this.blacklistProperty = property;
    }

    @Nullable
    public final Property getWhitelistProperty() {
        return this.whitelistProperty;
    }

    public final void setWhitelistProperty(@Nullable Property property) {
        this.whitelistProperty = property;
    }

    public final boolean matchesClass(@NotNull Block block) {
        Class it;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Class<?> blockClass = block.getClass();
        Iterable $this$forEach$iv = this.blackList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Class)element$iv;
            boolean bl = false;
            if (!it.isAssignableFrom(blockClass)) continue;
            return false;
        }
        $this$forEach$iv = this.whiteList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Class)element$iv;
            boolean bl = false;
            if (!it.isAssignableFrom(blockClass)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesID(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.blockIDs.contains(Block.field_149771_c.func_148757_b((Object)block));
    }

    public final boolean matchesID(int blockId) {
        return this.blockIDs.contains(blockId);
    }

    @Override
    public void attach(@NotNull Configuration target, @NotNull String langPrefix, @NotNull String categoryName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)langPrefix, (String)"langPrefix");
        Intrinsics.checkNotNullParameter((Object)categoryName, (String)"categoryName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.setLang(null);
        Pair<String[], String[]> defaults = this.readDefaults(this.domain, this.path);
        this.blacklistProperty = target.get(categoryName, propertyName + "Blacklist", (String[])defaults.getFirst());
        this.whitelistProperty = target.get(categoryName, propertyName + "Whitelist", (String[])defaults.getSecond());
        Object[] objectArray = new Property[2];
        Intrinsics.checkNotNull((Object)this.blacklistProperty);
        Intrinsics.checkNotNull((Object)this.whitelistProperty);
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Property it = (Property)element$iv;
            boolean bl = false;
            it.setConfigEntryClass(NonVerboseArrayEntry.class);
            it.setLanguageKey(langPrefix + '.' + categoryName + '.' + it.getName());
        }
        this.read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read() {
        Object[] objectArray = new Pair[2];
        Property property = this.blacklistProperty;
        Intrinsics.checkNotNull((Object)property);
        objectArray[0] = new Pair(this.blackList, (Object)property);
        Property property2 = this.whitelistProperty;
        Intrinsics.checkNotNull((Object)property2);
        objectArray[1] = new Pair(this.whiteList, (Object)property2);
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            ((List)it.getFirst()).clear();
            List list = (List)it.getFirst();
            String[] stringArray = ((Property)it.getSecond()).getStringList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getStringList(...)");
            Object[] objectArray2 = stringArray;
            List list2 = list;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                collection.add(Reflection.getJavaClass((String)it2));
            }
            list2.addAll(CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        }
        this.updateIDs();
    }

    public final void updateIDs() {
        this.blockIDs.clear();
        RegistryNamespaced registryNamespaced = Block.field_149771_c;
        Intrinsics.checkNotNullExpressionValue((Object)registryNamespaced, (String)"blockRegistry");
        Iterable $this$forEach$iv = (Iterable)registryNamespaced;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type net.minecraft.block.Block");
            if (!this.matchesClass((Block)it)) continue;
            this.blockIDs.add(Block.field_149771_c.func_148757_b(it));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getHasChanged() {
        Property property = this.blacklistProperty;
        if (property != null ? property.hasChanged() : false) return true;
        Property property2 = this.whitelistProperty;
        if (property2 == null) return false;
        boolean bl = property2.hasChanged();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    public List<Property> getGuiProperties() {
        Object[] objectArray = new Property[2];
        Intrinsics.checkNotNull((Object)this.whitelistProperty);
        Intrinsics.checkNotNull((Object)this.blacklistProperty);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String[], String[]> readDefaults(@NotNull String domain, @NotNull String path) {
        List<String> defaults;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ArrayList<String> blackList = new ArrayList<String>();
        ArrayList<String> whiteList = new ArrayList<String>();
        IResource iResource = Utils.get((IResourceManager)Utils.getResourceManager(), domain, path);
        List<String> list = defaults = iResource != null ? Utils.getLines(iResource) : null;
        if (defaults != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = defaults;
            boolean $i$f$map22 = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"//", (boolean)false, (int)2, null) && ((CharSequence)it).length() > 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                String it = (String)element$iv;
                boolean bl2 = false;
                if (StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) {
                    String string = it.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    bl = blackList.add(string);
                    continue;
                }
                bl = whiteList.add(it);
            }
        }
        Collection $this$toTypedArray$iv = blackList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        $this$toTypedArray$iv = whiteList;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return TuplesKt.to((Object)stringArray, (Object)thisCollection$iv.toArray(new String[0]));
    }

    @SubscribeEvent
    public final void onWorldLoad(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.world instanceof WorldClient) {
            this.updateIDs();
        }
    }
}

