/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.config.Config;
import mods.betterfoliage.client.integration.TFCIntegration;
import mods.betterfoliage.client.render.Utils;
import mods.betterfoliage.client.texture.GrassInfo;
import mods.betterfoliage.client.texture.GrassRegistry;
import mods.octarinecore.client.render.AbstractBlockRenderingHandler;
import mods.octarinecore.client.render.Axis;
import mods.octarinecore.client.render.BlockContext;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.Model;
import mods.octarinecore.client.render.ModelKt;
import mods.octarinecore.client.render.ModelRenderer;
import mods.octarinecore.client.render.ModelRendererKt;
import mods.octarinecore.client.render.Quad;
import mods.octarinecore.client.render.RenderBlocksKt;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.RendererHolder;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.ShadersKt;
import mods.octarinecore.client.render.ShadingContext;
import mods.octarinecore.client.render.ShadingKt;
import mods.octarinecore.client.render.Vertex;
import mods.octarinecore.client.resource.IconHolder;
import mods.octarinecore.client.resource.IconSet;
import mods.octarinecore.client.resource.ModelSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lmods/betterfoliage/client/render/RenderGrass;", "Lmods/octarinecore/client/render/AbstractBlockRenderingHandler;", "<init>", "()V", "normalIcons", "Lmods/octarinecore/client/resource/IconSet;", "getNormalIcons", "()Lmods/octarinecore/client/resource/IconSet;", "snowedIcons", "getSnowedIcons", "normalGenIcon", "Lmods/octarinecore/client/resource/IconHolder;", "getNormalGenIcon", "()Lmods/octarinecore/client/resource/IconHolder;", "snowedGenIcon", "getSnowedGenIcon", "grassModels", "Lmods/octarinecore/client/resource/ModelSet;", "getGrassModels", "()Lmods/octarinecore/client/resource/ModelSet;", "afterStitch", "", "isEligible", "", "ctx", "Lmods/octarinecore/client/render/BlockContext;", "render", "parent", "Lnet/minecraft/client/renderer/RenderBlocks;", "allowConnectedGrassSpecialCases", "Companion", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nRenderGrass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderGrass.kt\nmods/betterfoliage/client/render/RenderGrass\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ModelRenderer.kt\nmods/octarinecore/client/render/RenderVertex\n*L\n1#1,152:1\n11158#2:153\n11493#2,3:154\n155#3,5:157\n161#3,4:162\n161#3,4:166\n161#3,4:170\n*S KotlinDebug\n*F\n+ 1 RenderGrass.kt\nmods/betterfoliage/client/render/RenderGrass\n*L\n94#1:153\n94#1:154,3\n104#1:157,5\n106#1:162,4\n139#1:166,4\n141#1:170,4\n*E\n"})
public final class RenderGrass
extends AbstractBlockRenderingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IconSet normalIcons = this.iconSet("bettergrassandleaves", "better_grass_long_%d");
    @NotNull
    private final IconSet snowedIcons = this.iconSet("bettergrassandleaves", "better_grass_snowed_%d");
    @NotNull
    private final IconHolder normalGenIcon;
    @NotNull
    private final IconHolder snowedGenIcon;
    @NotNull
    private final ModelSet grassModels;
    @NotNull
    private static final Function2<Model, Integer, Unit> grassTopQuads = RenderGrass::grassTopQuads$lambda$12;

    public RenderGrass() {
        super("BetterFoliage");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"snowed", (Object)false)};
        this.normalGenIcon = this.iconStatic(Client.INSTANCE.getGenGrass().generatedResource("minecraft:tallgrass", pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)"snowed", (Object)true)};
        this.snowedGenIcon = this.iconStatic(Client.INSTANCE.getGenGrass().generatedResource("minecraft:tallgrass", pairArray));
        this.grassModels = this.modelSet(64, grassTopQuads);
    }

    @NotNull
    public final IconSet getNormalIcons() {
        return this.normalIcons;
    }

    @NotNull
    public final IconSet getSnowedIcons() {
        return this.snowedIcons;
    }

    @NotNull
    public final IconHolder getNormalGenIcon() {
        return this.normalGenIcon;
    }

    @NotNull
    public final IconHolder getSnowedGenIcon() {
        return this.snowedGenIcon;
    }

    @NotNull
    public final ModelSet getGrassModels() {
        return this.grassModels;
    }

    @Override
    public void afterStitch() {
        Client.INSTANCE.log(Level.INFO, "Registered " + this.normalIcons.getNum() + " grass textures");
        Client.INSTANCE.log(Level.INFO, "Registered " + this.snowedIcons.getNum() + " snowed grass textures");
    }

    @Override
    public boolean isEligible(@NotNull BlockContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return Config.INSTANCE.getEnabled() && ctx.getCameraDistance() < Config.shortGrass.INSTANCE.getDistance() && (Config.shortGrass.INSTANCE.getGrassEnabled() || Config.connectedGrass.INSTANCE.getEnabled()) && Config.blocks.INSTANCE.getGrass().matchesID(ctx.getBlock());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean render(@NotNull BlockContext ctx, @NotNull RenderBlocks parent) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Block it = ctx.block(Utils.getDown1());
        boolean bl = false;
        boolean isConnected = Config.blocks.INSTANCE.getDirt().matchesID(it) || Config.blocks.INSTANCE.getGrass().matchesID(it);
        boolean isSnowed = Utils.isSnow(ctx.block(Utils.getUp1()));
        boolean connectedGrass2 = isConnected && Config.connectedGrass.INSTANCE.getEnabled() && (!isSnowed || Config.connectedGrass.INSTANCE.getSnowEnabled()) && this.allowConnectedGrassSpecialCases(ctx);
        GrassInfo grassInfo = GrassRegistry.INSTANCE.getGrass().get(BlockContext.icon$default(ctx, ForgeDirection.UP, null, 2, null));
        if (grassInfo == null) {
            AbstractBlockRenderingHandler.renderWorldBlockBase$default(this, parent, 0, null, RenderBlocksKt.getAlwaysRender(), 6, null);
            return true;
        }
        IIcon cubeTexture = isSnowed ? ctx.icon(ForgeDirection.UP, Utils.getUp1()) : (IIcon)grassInfo.getGrassTopTexture();
        int blockColor = ctx.getBlockColor();
        if (connectedGrass2) {
            void $this$mapTo$iv$iv;
            if (AbstractBlockRenderingHandler.renderWorldBlockBase$default(this, parent, 0, null, RenderBlocksKt.getNeverRender(), 6, null)) {
                return true;
            }
            ForgeDirection[] $this$map$iv = GeometryKt.getForgeDirs();
            boolean $i$f$map = false;
            ForgeDirection[] forgeDirectionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var18_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                Int3 int3 = GeometryKt.getOffset((ForgeDirection)it2);
                ForgeDirection forgeDirection = it2.getOpposite();
                Intrinsics.checkNotNullExpressionValue((Object)forgeDirection, (String)"getOpposite(...)");
                collection.add(!ctx.shouldRenderSide(int3, forgeDirection));
            }
            List isHidden = (List)destination$iv$iv;
            ModelRenderer.render$default(RendererHolder.getModelRenderer(), ModelKt.getFullCube(), null, null, false, (arg_0, arg_1) -> RenderGrass.render$lambda$2(isHidden, arg_0, arg_1), (arg_0, arg_1, arg_2) -> RenderGrass.render$lambda$3(cubeTexture, arg_0, arg_1, arg_2), RenderGrass::render$lambda$4, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> RenderGrass.render$lambda$5(isSnowed, blockColor, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), 14, null);
        } else if (AbstractBlockRenderingHandler.renderWorldBlockBase$default(this, parent, 0, null, RenderBlocksKt.getAlwaysRender(), 6, null)) {
            return true;
        }
        if (!Config.shortGrass.INSTANCE.getGrassEnabled()) {
            return true;
        }
        if (isSnowed && !Config.shortGrass.INSTANCE.getSnowEnabled()) {
            return true;
        }
        if (ctx.block(Utils.getUp1()).func_149662_c()) {
            return true;
        }
        IconSet iconset = isSnowed ? this.snowedIcons : this.normalIcons;
        IconHolder iconGen = isSnowed ? this.snowedGenIcon : this.normalGenIcon;
        Integer[] rand = ctx.semiRandomArray(2);
        ModelRenderer.render$default(RendererHolder.getModelRenderer(), this.grassModels.get(rand[0]), Rotation.Companion.getIdentity(), ctx.getBlockCenter().plus(isSnowed ? Utils.getSnowOffset() : Double3.Companion.getZero()), false, null, Config.shortGrass.INSTANCE.getUseGenerated() ? (arg_0, arg_1, arg_2) -> RenderGrass.render$lambda$6(iconGen, arg_0, arg_1, arg_2) : (arg_0, arg_1, arg_2) -> RenderGrass.render$lambda$7(iconset, rand, arg_0, arg_1, arg_2), RenderGrass::render$lambda$8, isSnowed ? Utils.getWhitewash() : (grassInfo.getOverrideColor() != null ? (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> RenderGrass.render$lambda$9(grassInfo, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) : (TFCIntegration.INSTANCE.getGrass().matchesID(ctx.getBlock()) ? (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> RenderGrass.render$lambda$10(blockColor, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) : ModelRendererKt.getNoPost())), 24, null);
        return true;
    }

    private final boolean allowConnectedGrassSpecialCases(BlockContext ctx) {
        return !TFCIntegration.isTFCDirtOrGrass(ctx.getBlock());
    }

    private static final boolean render$lambda$2(List $isHidden, int qi, Quad quad) {
        Intrinsics.checkNotNullParameter((Object)quad, (String)"<unused var>");
        return (Boolean)$isHidden.get(qi) == false;
    }

    private static final IIcon render$lambda$3(IIcon $cubeTexture, ShadingContext shadingContext, int n, Quad quad) {
        Intrinsics.checkNotNullParameter((Object)shadingContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)quad, (String)"<unused var>");
        return $cubeTexture;
    }

    private static final int render$lambda$4(Quad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit render$lambda$5(boolean $isSnowed, int $blockColor, RenderVertex $this$render, ShadingContext ctx, int qi, Quad quad, int n, Vertex vertex) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"$this$render");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)quad, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"<unused var>");
        if ($isSnowed) {
            if (!ctx.getAoEnabled()) {
                void this_$iv;
                RenderVertex renderVertex = $this$render;
                float level$iv = 1.4f;
                boolean $i$f$setGrey = false;
                float grey$iv = Math.min((this_$iv.getRed() + this_$iv.getGreen() + this_$iv.getBlue()) * 0.333f * level$iv, 1.0f);
                this_$iv.setRed(grey$iv);
                this_$iv.setGreen(grey$iv);
                this_$iv.setBlue(grey$iv);
            }
        } else if (qi != ForgeDirection.UP.ordinal() && ctx.getAoEnabled()) {
            RenderVertex this_$iv = $this$render;
            boolean $i$f$multiplyColor = false;
            this_$iv.setRed(this_$iv.getRed() * ((float)($blockColor >> 16 & 0xFF) / 256.0f));
            this_$iv.setGreen(this_$iv.getGreen() * ((float)($blockColor >> 8 & 0xFF) / 256.0f));
            this_$iv.setBlue(this_$iv.getBlue() * ((float)($blockColor & 0xFF) / 256.0f));
        }
        return Unit.INSTANCE;
    }

    private static final IIcon render$lambda$6(IconHolder $iconGen, ShadingContext ctx, int qi, Quad q) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        IIcon iIcon = $iconGen.getIcon();
        Intrinsics.checkNotNull((Object)iIcon);
        return iIcon;
    }

    private static final IIcon render$lambda$7(IconSet $iconset, Integer[] $rand, ShadingContext ctx, int qi, Quad q) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        IIcon iIcon = $iconset.get($rand[qi & 1]);
        Intrinsics.checkNotNull((Object)iIcon);
        return iIcon;
    }

    private static final int render$lambda$8(Quad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit render$lambda$9(GrassInfo $grassInfo, RenderVertex $this$render, ShadingContext shadingContext, int n, Quad quad, int n2, Vertex vertex) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"$this$render");
        Intrinsics.checkNotNullParameter((Object)shadingContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)quad, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"<unused var>");
        RenderVertex renderVertex = $this$render;
        int color$iv = $grassInfo.getOverrideColor();
        boolean $i$f$multiplyColor = false;
        this_$iv.setRed(this_$iv.getRed() * ((float)(color$iv >> 16 & 0xFF) / 256.0f));
        this_$iv.setGreen(this_$iv.getGreen() * ((float)(color$iv >> 8 & 0xFF) / 256.0f));
        this_$iv.setBlue(this_$iv.getBlue() * ((float)(color$iv & 0xFF) / 256.0f));
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$10(int $blockColor, RenderVertex $this$render, ShadingContext shadingContext, int n, Quad quad, int n2, Vertex vertex) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"$this$render");
        Intrinsics.checkNotNullParameter((Object)shadingContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)quad, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"<unused var>");
        RenderVertex this_$iv = $this$render;
        boolean $i$f$multiplyColor = false;
        this_$iv.setRed(this_$iv.getRed() * ((float)($blockColor >> 16 & 0xFF) / 256.0f));
        this_$iv.setGreen(this_$iv.getGreen() * ((float)($blockColor >> 8 & 0xFF) / 256.0f));
        this_$iv.setBlue(this_$iv.getBlue() * ((float)($blockColor & 0xFF) / 256.0f));
        return Unit.INSTANCE;
    }

    private static final Quad grassTopQuads$lambda$12$lambda$11(int $modelIdx, Quad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.move(Utils.xzDisk($modelIdx).times(Config.shortGrass.INSTANCE.getHOffset()));
    }

    private static final Unit grassTopQuads$lambda$12(Model model, int modelIdx) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"<this>");
        model.addAll((Iterable<Quad>)Utils.toCross(Quad.setFlatShader$default(Quad.setAoShader$default(model.verticalRectangle(-0.5, 0.5, 0.5, -0.5, 0.5, 0.5 + mods.octarinecore.Utils.random(Config.shortGrass.INSTANCE.getHeightMin(), Config.shortGrass.INSTANCE.getHeightMax())), ShadingKt.faceOrientedAuto$default(ForgeDirection.UP, ShadersKt.cornerAo(Axis.Y), null, 4, null), null, 2, null), ShadingKt.faceOrientedAuto$default(ForgeDirection.UP, ShadersKt.getCornerFlat(), null, 4, null), null, 2, null), ForgeDirection.UP, (Function1<? super Quad, Quad>)((Function1)arg_0 -> RenderGrass.grassTopQuads$lambda$12$lambda$11(modelIdx, arg_0))));
        return Unit.INSTANCE;
    }

    @NotNull
    public static final Function2<Model, Integer, Unit> getGrassTopQuads() {
        return Companion.getGrassTopQuads();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R3\u0010\u0004\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmods/betterfoliage/client/render/RenderGrass$Companion;", "", "<init>", "()V", "grassTopQuads", "Lkotlin/Function2;", "Lmods/octarinecore/client/render/Model;", "", "", "Lkotlin/ExtensionFunctionType;", "getGrassTopQuads$annotations", "getGrassTopQuads", "()Lkotlin/jvm/functions/Function2;", "BetterFoliage-LegacyEdition"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<Model, Integer, Unit> getGrassTopQuads() {
            return grassTopQuads;
        }

        @JvmStatic
        public static /* synthetic */ void getGrassTopQuads$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

