/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.betterfoliage.client.integration.GT5UIntegration;
import mods.betterfoliage.client.integration.GT6Integration;
import mods.betterfoliage.client.integration.OptifineCTM;
import mods.betterfoliage.loader.Refs;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.metaprog.MethodRef;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020+2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001a\u00105\u001a\u00020)2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)07J\u000e\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000bJ\u0019\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0;2\u0006\u0010<\u001a\u00020\u000b\u00a2\u0006\u0002\u0010=J\u001a\u0010@\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0013\u0010 \u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u0011\u0010&\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0011\u0010,\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\rR\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u0010>\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\r\u00a8\u0006B"}, d2={"Lmods/octarinecore/client/render/BlockContext;", "", "<init>", "()V", "world", "Lnet/minecraft/world/IBlockAccess;", "getWorld", "()Lnet/minecraft/world/IBlockAccess;", "setWorld", "(Lnet/minecraft/world/IBlockAccess;)V", "x", "", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "z", "getZ", "setZ", "set", "", "block", "Lnet/minecraft/block/Block;", "getBlock", "()Lnet/minecraft/block/Block;", "offset", "Lmods/octarinecore/client/render/Int3;", "meta", "getMeta", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;", "getTileEntity", "()Lnet/minecraft/tileentity/TileEntity;", "blockColor", "getBlockColor", "blockBrightness", "getBlockBrightness", "shouldRenderSide", "", "side", "Lnet/minecraftforge/common/util/ForgeDirection;", "biomeId", "getBiomeId", "icon", "Lnet/minecraft/util/IIcon;", "face", "blockCenter", "Lmods/octarinecore/client/render/Double3;", "getBlockCenter", "()Lmods/octarinecore/client/render/Double3;", "isSurroundedBy", "predicate", "Lkotlin/Function1;", "random", "seed", "semiRandomArray", "", "num", "(I)[Ljava/lang/Integer;", "cameraDistance", "getCameraDistance", "getIconSpecialCases", "Companion", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nAbstractBlockRenderingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBlockRenderingHandler.kt\nmods/octarinecore/client/render/BlockContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1734#2,3:216\n*S KotlinDebug\n*F\n+ 1 AbstractBlockRenderingHandler.kt\nmods/octarinecore/client/render/BlockContext\n*L\n192#1:216,3\n*E\n"})
public final class BlockContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IBlockAccess world;
    private int x;
    private int y;
    private int z;

    @Nullable
    public final IBlockAccess getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable IBlockAccess iBlockAccess) {
        this.world = iBlockAccess;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setZ(int n) {
        this.z = n;
    }

    public final void set(@NotNull IBlockAccess world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public final Block getBlock() {
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        Block block = iBlockAccess.func_147439_a(this.x, this.y, this.z);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return block;
    }

    @NotNull
    public final Block block(@NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        Block block = iBlockAccess.func_147439_a(this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ());
        Intrinsics.checkNotNull((Object)block);
        return block;
    }

    public final int getMeta() {
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        return iBlockAccess.func_72805_g(this.x, this.y, this.z);
    }

    public final int meta(@NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        return iBlockAccess.func_72805_g(this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ());
    }

    @Nullable
    public final TileEntity getTileEntity() {
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        return iBlockAccess.func_147438_o(this.x, this.y, this.z);
    }

    @Nullable
    public final TileEntity tileEntity(@NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        return iBlockAccess.func_147438_o(this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ());
    }

    public final int getBlockColor() {
        return Companion.blockColor(this.getBlock(), this.world, this.x, this.y, this.z);
    }

    public final int blockColor(@NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return Companion.blockColor(this.block(offset), this.world, this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ());
    }

    public final int getBlockBrightness() {
        return this.getBlock().func_149677_c(this.world, this.x, this.y, this.z);
    }

    public final int blockBrightness(@NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return this.block(offset).func_149677_c(this.world, this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ());
    }

    public final boolean shouldRenderSide(@NotNull Int3 offset, @NotNull ForgeDirection side) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.getBlock().func_149646_a(this.world, this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ(), side.ordinal());
    }

    public final int getBiomeId() {
        IBlockAccess iBlockAccess = this.world;
        Intrinsics.checkNotNull((Object)iBlockAccess);
        return iBlockAccess.func_72807_a((int)this.x, (int)this.z).field_76756_M;
    }

    @NotNull
    public final IIcon icon(@NotNull ForgeDirection face, @NotNull Int3 offset) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        IIcon iIcon = this.getIconSpecialCases(face, offset);
        if (iIcon == null) {
            IIcon it = this.block(offset).func_149673_e(this.world, this.x + offset.getX(), this.y + offset.getY(), this.z + offset.getZ(), face.ordinal());
            boolean bl = false;
            if (!OptifineCTM.INSTANCE.isAvailable()) {
                IIcon iIcon2 = it;
                iIcon = iIcon2;
                Intrinsics.checkNotNull((Object)iIcon2);
            } else {
                MethodRef methodRef = Refs.INSTANCE.getGetConnectedTexture();
                Object[] objectArray = new Object[7];
                Intrinsics.checkNotNull((Object)this.world);
                objectArray[1] = this.block(offset);
                objectArray[2] = this.x + offset.getX();
                objectArray[3] = this.y + offset.getY();
                objectArray[4] = this.z + offset.getZ();
                objectArray[5] = face.ordinal();
                objectArray[6] = it;
                Object object = methodRef.invokeStatic(objectArray);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.util.IIcon");
                iIcon = (IIcon)object;
            }
        }
        return iIcon;
    }

    public static /* synthetic */ IIcon icon$default(BlockContext blockContext, ForgeDirection forgeDirection, Int3 int3, int n, Object object) {
        if ((n & 2) != 0) {
            int3 = Int3.Companion.getZero();
        }
        return blockContext.icon(forgeDirection, int3);
    }

    @NotNull
    public final Double3 getBlockCenter() {
        return new Double3((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    public final boolean isSurroundedBy(@NotNull Function1<? super Block, Boolean> predicate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$all$iv = GeometryKt.getForgeDirOffsets();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Int3 it = (Int3)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)predicate.invoke((Object)this.block(it))).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final int random(int seed) {
        int value = this.x * this.x + this.y * this.y + this.z * this.z + this.x * this.y + this.y * this.z + this.z * this.x + seed * seed & 0x3F;
        value = 3 * this.x * value + 5 * this.y * value + 7 * this.z * value + 11 * seed & 0x3F;
        return value;
    }

    @NotNull
    public final Integer[] semiRandomArray(int num) {
        int n = 0;
        Integer[] integerArray = new Integer[num];
        while (n < num) {
            int n2 = n++;
            integerArray[n2] = this.random(n2);
        }
        return integerArray;
    }

    public final int getCameraDistance() {
        EntityLivingBase entityLivingBase = Minecraft.func_71410_x().field_71451_h;
        if (entityLivingBase == null) {
            return 0;
        }
        EntityLivingBase camera = entityLivingBase;
        return Math.abs(this.x - MathHelper.func_76128_c((double)camera.field_70165_t)) + Math.abs(this.y - MathHelper.func_76128_c((double)camera.field_70163_u)) + Math.abs(this.z - MathHelper.func_76128_c((double)camera.field_70161_v));
    }

    private final IIcon getIconSpecialCases(ForgeDirection face, Int3 offset) {
        return GT6Integration.INSTANCE.getGT6LogMTEIcon(this, face, offset);
    }

    @JvmStatic
    public static final int blockColor(@NotNull Block block, @Nullable IBlockAccess world, int x, int y, int z) {
        return Companion.blockColor(block, world, x, y, z);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a8\u0006\r"}, d2={"Lmods/octarinecore/client/render/BlockContext$Companion;", "", "<init>", "()V", "blockColor", "", "block", "Lnet/minecraft/block/Block;", "world", "Lnet/minecraft/world/IBlockAccess;", "x", "y", "z", "BetterFoliage-LegacyEdition"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int blockColor(@NotNull Block block, @Nullable IBlockAccess world, int x, int y, int z) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            int it = block.func_149720_d(world, x, y, z);
            boolean bl = false;
            return GT5UIntegration.tryTintWithPollution(it, block, x, z);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

