/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.octarinecore.client.render.AoData;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.PixelFormat;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.Shader;
import mods.octarinecore.client.render.ShadingContext;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lmods/octarinecore/client/render/FaceCenter;", "Lmods/octarinecore/client/render/Shader;", "face", "Lnet/minecraftforge/common/util/ForgeDirection;", "<init>", "(Lnet/minecraftforge/common/util/ForgeDirection;)V", "getFace", "()Lnet/minecraftforge/common/util/ForgeDirection;", "shade", "", "context", "Lmods/octarinecore/client/render/ShadingContext;", "vertex", "Lmods/octarinecore/client/render/RenderVertex;", "rotate", "rot", "Lmods/octarinecore/client/render/Rotation;", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nShaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shaders.kt\nmods/octarinecore/client/render/FaceCenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1872#2,3:209\n*S KotlinDebug\n*F\n+ 1 Shaders.kt\nmods/octarinecore/client/render/FaceCenter\n*L\n166#1:209,3\n*E\n"})
public final class FaceCenter
implements Shader {
    @NotNull
    private final ForgeDirection face;

    public FaceCenter(@NotNull ForgeDirection face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        this.face = face;
    }

    @NotNull
    public final ForgeDirection getFace() {
        return this.face;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shade(@NotNull ShadingContext context, @NotNull RenderVertex vertex) {
        RenderVertex renderVertex;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        vertex.setRed(0.0f);
        vertex.setGreen(0.0f);
        vertex.setBlue(0.0f);
        int[] b = new int[4];
        Iterable $this$forEachIndexed$iv = GeometryKt.getFaceCorners().get(this.face.ordinal()).getAsList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void corner;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int idx = n;
            boolean bl = false;
            AoData shading = context.aoShading(this.face, (ForgeDirection)corner.getFirst(), (ForgeDirection)corner.getSecond());
            vertex.setRed(vertex.getRed() + shading.getRed());
            vertex.setGreen(vertex.getGreen() + shading.getGreen());
            vertex.setBlue(vertex.getBlue() + shading.getBlue());
            b[idx] = shading.getBrightness();
        }
        RenderVertex $this$shade_u24lambda_u241 = renderVertex = vertex;
        boolean bl = false;
        $this$shade_u24lambda_u241.setRed($this$shade_u24lambda_u241.getRed() * 0.25f);
        $this$shade_u24lambda_u241.setGreen($this$shade_u24lambda_u241.getGreen() * 0.25f);
        $this$shade_u24lambda_u241.setBlue($this$shade_u24lambda_u241.getBlue() * 0.25f);
        vertex.setBrightness(PixelFormat.brSum(Float.valueOf(0.25f), Arrays.copyOf(b, b.length)));
    }

    @Override
    @NotNull
    public FaceCenter rotate(@NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        return new FaceCenter(GeometryKt.rotate(this.face, rot));
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading) {
        Shader.DefaultImpls.shade(this, $this$shade, shading);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, @NotNull AoData shading1, @NotNull AoData shading2, float weight1, float weight2) {
        Shader.DefaultImpls.shade(this, $this$shade, shading1, shading2, weight1, weight2);
    }

    @Override
    public void shade(@NotNull RenderVertex $this$shade, int brightness, int color) {
        Shader.DefaultImpls.shade(this, $this$shade, brightness, color);
    }
}

