/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mods.octarinecore.Utils;
import mods.octarinecore.client.render.Axis;
import mods.octarinecore.client.render.Dir;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.FaceCorners;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.Rotation;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\"\u001a\u00020#*\u00020\n2\u0006\u0010$\u001a\u00020%H\u0086\u0002\u001a\u0012\u0010,\u001a\u00020\n*\u00020\n2\u0006\u0010-\u001a\u00020.\u001a\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\n\u001aB\u00101\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u00020%0\u0019\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020#2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H2052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u00020#07\u001aB\u00108\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u00020%0\u0019\"\u0004\b\u0000\u001022\u0006\u00109\u001a\u00020#2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H2052\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u00020#07\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"7\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\u000e\b\u0001\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t0\t\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0004\"\u0015\u0010\u0012\u001a\u00020\u0002*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"!\u0010\u0018\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020\u0010*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010&\u001a\u00020#*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"3\u0010/\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u00190\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0004\"\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0004\"\u0015\u0010>\u001a\u00020#*\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\"\u0015\u0010$\u001a\u00020#*\u00020?8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010A\u00a8\u0006C"}, d2={"axes", "", "Lmods/octarinecore/client/render/Axis;", "getAxes", "()Ljava/util/List;", "axisDirs", "Lmods/octarinecore/client/render/Dir;", "getAxisDirs", "forgeDirs", "", "Lnet/minecraftforge/common/util/ForgeDirection;", "kotlin.jvm.PlatformType", "getForgeDirs", "()[Lnet/minecraftforge/common/util/ForgeDirection;", "[Lnet/minecraftforge/common/util/ForgeDirection;", "forgeDirOffsets", "Lmods/octarinecore/client/render/Int3;", "getForgeDirOffsets", "axis", "getAxis", "(Lnet/minecraftforge/common/util/ForgeDirection;)Lmods/octarinecore/client/render/Axis;", "dir", "getDir", "(Lnet/minecraftforge/common/util/ForgeDirection;)Lmods/octarinecore/client/render/Dir;", "face", "Lkotlin/Pair;", "getFace", "(Lkotlin/Pair;)Lnet/minecraftforge/common/util/ForgeDirection;", "perpendiculars", "getPerpendiculars", "(Lnet/minecraftforge/common/util/ForgeDirection;)Ljava/util/List;", "offset", "getOffset", "(Lnet/minecraftforge/common/util/ForgeDirection;)Lmods/octarinecore/client/render/Int3;", "times", "Lmods/octarinecore/client/render/Double3;", "scale", "", "vec", "getVec", "(Lnet/minecraftforge/common/util/ForgeDirection;)Lmods/octarinecore/client/render/Double3;", "rotations", "getRotations", "(Lnet/minecraftforge/common/util/ForgeDirection;)[Lnet/minecraftforge/common/util/ForgeDirection;", "rotate", "rot", "Lmods/octarinecore/client/render/Rotation;", "boxEdges", "getBoxEdges", "nearestPosition", "T", "vertex", "objs", "", "objPos", "Lkotlin/Function1;", "nearestAngle", "vector", "objAngle", "faceCorners", "Lmods/octarinecore/client/render/FaceCorners;", "getFaceCorners", "center", "Lnet/minecraft/util/AxisAlignedBB;", "getCenter", "(Lnet/minecraft/util/AxisAlignedBB;)Lmods/octarinecore/client/render/Double3;", "getScale", "BetterFoliage-LegacyEdition"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\nmods/octarinecore/client/render/GeometryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,402:1\n774#2:403\n865#2,2:404\n1557#2:406\n1628#2,3:407\n1557#2:410\n1628#2,3:411\n2318#2,14:414\n1557#2:428\n1628#2,3:429\n1948#2,14:432\n1557#2:456\n1628#2,3:457\n11158#3:446\n11493#3,3:447\n10065#3:450\n10487#3,2:451\n3829#3:453\n4344#3,2:454\n10489#3,3:460\n11158#3:463\n11493#3,3:464\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\nmods/octarinecore/client/render/GeometryKt\n*L\n59#1:403\n59#1:404,2\n59#1:406\n59#1:407,3\n342#1:410\n342#1:411,3\n342#1:414,14\n356#1:428\n356#1:429,3\n356#1:432,14\n328#1:456\n328#1:457,3\n26#1:446\n26#1:447,3\n328#1:450\n328#1:451,2\n328#1:453\n328#1:454,2\n328#1:460,3\n373#1:463\n373#1:464,3\n*E\n"})
public final class GeometryKt {
    @NotNull
    private static final List<Axis> axes;
    @NotNull
    private static final List<Dir> axisDirs;
    @NotNull
    private static final ForgeDirection[] forgeDirs;
    @NotNull
    private static final List<Int3> forgeDirOffsets;
    @NotNull
    private static final List<Pair<ForgeDirection, ForgeDirection>> boxEdges;
    @NotNull
    private static final List<FaceCorners> faceCorners;

    @NotNull
    public static final List<Axis> getAxes() {
        return axes;
    }

    @NotNull
    public static final List<Dir> getAxisDirs() {
        return axisDirs;
    }

    @NotNull
    public static final ForgeDirection[] getForgeDirs() {
        return forgeDirs;
    }

    @NotNull
    public static final List<Int3> getForgeDirOffsets() {
        return forgeDirOffsets;
    }

    @NotNull
    public static final Axis getAxis(@NotNull ForgeDirection $this$axis) {
        Axis axis;
        Intrinsics.checkNotNullParameter((Object)$this$axis, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$axis.ordinal()]) {
            case 1: 
            case 2: {
                axis = Axis.X;
                break;
            }
            case 3: 
            case 4: {
                axis = Axis.Y;
                break;
            }
            default: {
                axis = Axis.Z;
            }
        }
        return axis;
    }

    @NotNull
    public static final Dir getDir(@NotNull ForgeDirection $this$dir) {
        Dir dir;
        Intrinsics.checkNotNullParameter((Object)$this$dir, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$dir.ordinal()]) {
            case 1: 
            case 3: 
            case 5: {
                dir = Dir.P;
                break;
            }
            default: {
                dir = Dir.N;
            }
        }
        return dir;
    }

    @NotNull
    public static final ForgeDirection getFace(@NotNull Pair<? extends Axis, ? extends Dir> $this$face) {
        Intrinsics.checkNotNullParameter($this$face, (String)"<this>");
        Pair<? extends Axis, ? extends Dir> pair = $this$face;
        return Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.X), (Object)((Object)Dir.P))) ? ForgeDirection.EAST : (Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.X), (Object)((Object)Dir.N))) ? ForgeDirection.WEST : (Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.Y), (Object)((Object)Dir.P))) ? ForgeDirection.UP : (Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.Y), (Object)((Object)Dir.N))) ? ForgeDirection.DOWN : (Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.Z), (Object)((Object)Dir.P))) ? ForgeDirection.SOUTH : (Intrinsics.areEqual(pair, (Object)TuplesKt.to((Object)((Object)Axis.Z), (Object)((Object)Dir.N))) ? ForgeDirection.NORTH : ForgeDirection.UNKNOWN)))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ForgeDirection> getPerpendiculars(@NotNull ForgeDirection $this$perpendiculars) {
        void $this$mapTo$iv$iv;
        Axis it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$perpendiculars, (String)"<this>");
        Iterable $this$filter$iv = axes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Axis)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it != GeometryKt.getAxis($this$perpendiculars))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = Utils.cross((List)destination$iv$iv, (Iterable)axisDirs);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GeometryKt.getFace((Pair<? extends Axis, ? extends Dir>)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Int3 getOffset(@NotNull ForgeDirection $this$offset) {
        Intrinsics.checkNotNullParameter((Object)$this$offset, (String)"<this>");
        return forgeDirOffsets.get($this$offset.ordinal());
    }

    @NotNull
    public static final Double3 times(@NotNull ForgeDirection $this$times, double scale) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Double3((double)$this$times.offsetX * scale, (double)$this$times.offsetY * scale, (double)$this$times.offsetZ * scale);
    }

    @NotNull
    public static final Double3 getVec(@NotNull ForgeDirection $this$vec) {
        Intrinsics.checkNotNullParameter((Object)$this$vec, (String)"<this>");
        return new Double3((double)$this$vec.offsetX, (double)$this$vec.offsetY, (double)$this$vec.offsetZ);
    }

    @NotNull
    public static final ForgeDirection[] getRotations(@NotNull ForgeDirection $this$rotations) {
        Intrinsics.checkNotNullParameter((Object)$this$rotations, (String)"<this>");
        int n = 0;
        ForgeDirection[] forgeDirectionArray = new ForgeDirection[6];
        while (n < 6) {
            int n2 = n++;
            forgeDirectionArray[n2] = EntriesMappings.entries$0.get(ForgeDirection.ROTATION_MATRIX[$this$rotations.ordinal()][n2]);
        }
        return forgeDirectionArray;
    }

    @NotNull
    public static final ForgeDirection rotate(@NotNull ForgeDirection $this$rotate, @NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        return rot.getForward()[$this$rotate.ordinal()];
    }

    @NotNull
    public static final Rotation rot(@NotNull ForgeDirection axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return Rotation.Companion.getRot90()[axis.ordinal()];
    }

    @NotNull
    public static final List<Pair<ForgeDirection, ForgeDirection>> getBoxEdges() {
        return boxEdges;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Pair<T, Double> nearestPosition(@NotNull Double3 vertex, @NotNull Iterable<? extends T> objs, @NotNull Function1<? super T, Double3> objPos) {
        Object t;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        Intrinsics.checkNotNullParameter(objs, (String)"objs");
        Intrinsics.checkNotNullParameter(objPos, (String)"objPos");
        Iterable<? extends T> $this$map$iv = objs;
        boolean $i$f$map = false;
        Iterable<? extends T> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)((Double3)objPos.invoke((Object)it)).minus(vertex).getLength()));
        }
        Iterable $this$minBy$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            Pair it = (Pair)minElem$iv;
            boolean bl = false;
            double minValue$iv = ((Number)it.getSecond()).doubleValue();
            do {
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                $i$a$-minByOrThrow-GeometryKt$nearestPosition$2 = false;
                double v$iv = ((Number)it2.getSecond()).doubleValue();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        return (Pair)t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Pair<T, Double> nearestAngle(@NotNull Double3 vector, @NotNull Iterable<? extends T> objs, @NotNull Function1<? super T, Double3> objAngle) {
        Object t;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter(objs, (String)"objs");
        Intrinsics.checkNotNullParameter(objAngle, (String)"objAngle");
        Iterable<? extends T> $this$map$iv = objs;
        boolean $i$f$map = false;
        Iterable<? extends T> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)((Double3)objAngle.invoke((Object)it)).dot(vector)));
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            Pair it = (Pair)maxElem$iv;
            boolean bl = false;
            double maxValue$iv = ((Number)it.getSecond()).doubleValue();
            do {
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                $i$a$-maxByOrThrow-GeometryKt$nearestAngle$2 = false;
                double v$iv = ((Number)it2.getSecond()).doubleValue();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        return (Pair)t;
    }

    @NotNull
    public static final List<FaceCorners> getFaceCorners() {
        return faceCorners;
    }

    @NotNull
    public static final Double3 getCenter(@NotNull AxisAlignedBB $this$center) {
        Intrinsics.checkNotNullParameter((Object)$this$center, (String)"<this>");
        return new Double3(($this$center.field_72340_a + $this$center.field_72336_d) / 2.0, ($this$center.field_72338_b + $this$center.field_72337_e) / 2.0, ($this$center.field_72339_c + $this$center.field_72334_f) / 2.0);
    }

    @NotNull
    public static final Double3 getScale(@NotNull AxisAlignedBB $this$scale) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        return new Double3($this$scale.field_72336_d - $this$scale.field_72340_a, $this$scale.field_72337_e - $this$scale.field_72338_b, $this$scale.field_72334_f - $this$scale.field_72339_c);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object list$iv$iv;
        int n;
        ForgeDirection[] $this$flatMapTo$iv$iv;
        void it;
        Collection collection;
        ForgeDirection[] $this$mapTo$iv$iv;
        Enum[] enumArray = new Axis[]{Axis.X, Axis.Y, Axis.Z};
        axes = CollectionsKt.listOf((Object[])enumArray);
        enumArray = new Dir[]{Dir.P, Dir.N};
        axisDirs = CollectionsKt.listOf((Object[])enumArray);
        Intrinsics.checkNotNull((Object)ForgeDirection.VALID_DIRECTIONS);
        ForgeDirection[] $this$map$iv = forgeDirs = ForgeDirection.VALID_DIRECTIONS;
        boolean $i$f$map = false;
        ForgeDirection[] forgeDirectionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (ForgeDirection item$iv$iv : $this$mapTo$iv$iv) {
            void var8_9 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new Int3((ForgeDirection)it));
        }
        forgeDirOffsets = (List)destination$iv$iv;
        ForgeDirection[] $this$flatMap$iv = forgeDirs;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n2 = $this$flatMapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv;
            void element$iv$iv;
            void face1 = element$iv$iv = $this$flatMapTo$iv$iv[n];
            boolean bl = false;
            Object $this$filter$iv = forgeDirs;
            boolean $i$f$filter = false;
            ForgeDirection[] forgeDirectionArray2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (ForgeDirection element$iv$iv2 : $this$filterTo$iv$iv) {
                void it2 = element$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                Axis axis = GeometryKt.getAxis((ForgeDirection)it2);
                Intrinsics.checkNotNull((Object)face1);
                if (!(axis.compareTo((Enum)GeometryKt.getAxis((ForgeDirection)face1)) > 0)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                ForgeDirection element$iv$iv2;
                element$iv$iv2 = (ForgeDirection)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                collection2.add(TuplesKt.to((Object)face1, (Object)it3));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        boxEdges = (List)destination$iv$iv;
        $this$map$iv = forgeDirs;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            FaceCorners faceCorners;
            ForgeDirection item$iv$iv;
            list$iv$iv = item$iv$iv = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            switch (v1 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                case 4: {
                    faceCorners = new FaceCorners(ForgeDirection.SOUTH, ForgeDirection.WEST);
                    break;
                }
                case 3: {
                    faceCorners = new FaceCorners(ForgeDirection.SOUTH, ForgeDirection.EAST);
                    break;
                }
                case 6: {
                    faceCorners = new FaceCorners(ForgeDirection.WEST, ForgeDirection.UP);
                    break;
                }
                case 5: {
                    faceCorners = new FaceCorners(ForgeDirection.UP, ForgeDirection.WEST);
                    break;
                }
                case 2: {
                    faceCorners = new FaceCorners(ForgeDirection.SOUTH, ForgeDirection.UP);
                    break;
                }
                case 1: {
                    faceCorners = new FaceCorners(ForgeDirection.SOUTH, ForgeDirection.DOWN);
                    break;
                }
                default: {
                    faceCorners = new FaceCorners(ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN);
                }
            }
            collection.add(faceCorners);
        }
        faceCorners = (List)var3_3;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ForgeDirection> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ForgeDirection.values()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ForgeDirection.values().length];
            try {
                nArray[ForgeDirection.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.SOUTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.NORTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

