/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0007\u001a\u0015\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0004\u001a!\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\t2\n\u0010\r\u001a\u00020\u000e\"\u00020\u0002\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\t\" \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"brightnessComponents", "", "", "getBrightnessComponents", "()Ljava/util/List;", "setBrightnessComponents", "(Ljava/util/List;)V", "brMul", "f", "", "colorMul", "brSum", "multiplier", "brightness", "", "(Ljava/lang/Float;[I)I", "brWeighted", "br1", "weight1", "br2", "weight2", "BetterFoliage-LegacyEdition"})
@JvmName(name="PixelFormat")
@SourceDebugExtension(value={"SMAP\nPixelFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PixelFormat.kt\nmods/octarinecore/client/render/PixelFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n1863#2,2:80\n1872#2,2:82\n1874#2:86\n1872#2,3:87\n1872#2,3:90\n13423#3,2:84\n*S KotlinDebug\n*F\n+ 1 PixelFormat.kt\nmods/octarinecore/client/render/PixelFormat\n*L\n16#1:80,2\n36#1:82,2\n36#1:86\n43#1:87,3\n59#1:90,3\n37#1:84,2\n*E\n"})
public final class PixelFormat {
    @NotNull
    private static List<Integer> brightnessComponents;

    @NotNull
    public static final List<Integer> getBrightnessComponents() {
        return brightnessComponents;
    }

    public static final void setBrightnessComponents(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        brightnessComponents = list;
    }

    public static final int brMul(int $this$brMul, float f) {
        int weight = (int)(f * 256.0f);
        int result = 0;
        Iterable $this$forEach$iv = brightnessComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int shift = ((Number)element$iv).intValue();
            boolean bl = false;
            int raw = $this$brMul >> shift & 0xF;
            int weighted = raw * weight / 256;
            result |= weighted << shift;
        }
        return result;
    }

    public static final int colorMul(int $this$colorMul, float f) {
        int weight = (int)(f * 256.0f);
        int red = ($this$colorMul >> 16 & 0xFF) * weight / 256;
        int green = ($this$colorMul >> 8 & 0xFF) * weight / 256;
        int blue = ($this$colorMul & 0xFF) * weight / 256;
        return red << 16 | green << 8 | blue;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brSum(@Nullable Float multiplier, int ... brightness) {
        int idx;
        int n;
        Intrinsics.checkNotNullParameter((Object)brightness, (String)"brightness");
        int n2 = 0;
        int n3 = brightnessComponents.size();
        Integer[] integerArray = new Integer[n3];
        while (n2 < n3) {
            int n4 = n2++;
            integerArray[n4] = 0;
        }
        Integer[] sum = integerArray;
        Iterable $this$forEachIndexed$iv = brightnessComponents;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n5;
            if ((n5 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = ((Number)item$iv).intValue();
            idx = n5;
            boolean bl = false;
            int[] $this$forEach$iv = brightness;
            boolean $i$f$forEach = false;
            int n6 = $this$forEach$iv.length;
            for (int i = 0; i < n6; ++i) {
                void shift;
                int element$iv;
                int br = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                int comp = br >> shift & 0xF;
                sum[idx] = sum[idx] + comp;
            }
        }
        int result = 0;
        Iterable $this$forEachIndexed$iv2 = brightnessComponents;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void shift;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            idx = ((Number)item$iv).intValue();
            int idx2 = n;
            boolean bl = false;
            int comp = multiplier == null ? sum[idx2] << shift : (int)((float)sum[idx2].intValue() * multiplier.floatValue()) << shift;
            result |= comp;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brWeighted(int br1, float weight1, int br2, float weight2) {
        int w1int = (int)(weight1 * 256.0f + 0.5f);
        int w2int = (int)(weight2 * 256.0f + 0.5f);
        int result = 0;
        Iterable $this$forEachIndexed$iv = brightnessComponents;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void shift;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int idx = n;
            boolean bl = false;
            int comp1 = br1 >> shift & 0xF;
            int comp2 = br2 >> shift & 0xF;
            int compWeighted = (comp1 * w1int + comp2 * w2int) / 256;
            result |= (compWeighted & 0xF) << shift;
        }
        return result;
    }

    static {
        Object[] objectArray = new Integer[]{20, 4};
        brightnessComponents = CollectionsKt.listOf((Object[])objectArray);
    }
}

