/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.client.render.GeometryKt;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J)\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0086\bJ)\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0019"}, d2={"Lmods/octarinecore/client/render/Rotation;", "", "forward", "", "Lnet/minecraftforge/common/util/ForgeDirection;", "reverse", "<init>", "([Lnet/minecraftforge/common/util/ForgeDirection;[Lnet/minecraftforge/common/util/ForgeDirection;)V", "getForward", "()[Lnet/minecraftforge/common/util/ForgeDirection;", "[Lnet/minecraftforge/common/util/ForgeDirection;", "getReverse", "plus", "other", "unaryMinus", "times", "num", "", "rotatedComponent", "dir", "x", "y", "z", "", "Companion", "BetterFoliage-LegacyEdition"})
public final class Rotation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForgeDirection[] forward;
    @NotNull
    private final ForgeDirection[] reverse;
    @NotNull
    private static final Rotation[] rot90;
    @NotNull
    private static final Rotation identity;

    public Rotation(@NotNull ForgeDirection[] forward, @NotNull ForgeDirection[] reverse) {
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)reverse, (String)"reverse");
        this.forward = forward;
        this.reverse = reverse;
    }

    @NotNull
    public final ForgeDirection[] getForward() {
        return this.forward;
    }

    @NotNull
    public final ForgeDirection[] getReverse() {
        return this.reverse;
    }

    @NotNull
    public final Rotation plus(@NotNull Rotation other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n2 = 0;
        ForgeDirection[] forgeDirectionArray = new ForgeDirection[6];
        while (n2 < 6) {
            n = n2++;
            forgeDirectionArray[n] = this.forward[other.forward[n].ordinal()];
        }
        ForgeDirection[] forgeDirectionArray2 = forgeDirectionArray;
        n2 = 0;
        forgeDirectionArray = new ForgeDirection[6];
        ForgeDirection[] forgeDirectionArray3 = forgeDirectionArray2;
        while (n2 < 6) {
            n = n2++;
            forgeDirectionArray[n] = other.reverse[this.reverse[n].ordinal()];
        }
        ForgeDirection[] forgeDirectionArray4 = forgeDirectionArray;
        ForgeDirection[] forgeDirectionArray5 = forgeDirectionArray3;
        return new Rotation(forgeDirectionArray5, forgeDirectionArray4);
    }

    @NotNull
    public final Rotation unaryMinus() {
        return new Rotation(this.reverse, this.forward);
    }

    @NotNull
    public final Rotation times(int num) {
        Rotation rotation;
        switch (num % 4) {
            case 1: {
                rotation = this;
                break;
            }
            case 2: {
                rotation = this.plus(this);
                break;
            }
            case 3: {
                rotation = this.unaryMinus();
                break;
            }
            default: {
                rotation = identity;
            }
        }
        return rotation;
    }

    public final int rotatedComponent(@NotNull ForgeDirection dir, int x, int y, int z) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        boolean $i$f$rotatedComponent = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getReverse()[dir.ordinal()].ordinal()]) {
            case 1: {
                n = x;
                break;
            }
            case 2: {
                n = -x;
                break;
            }
            case 3: {
                n = y;
                break;
            }
            case 4: {
                n = -y;
                break;
            }
            case 5: {
                n = z;
                break;
            }
            case 6: {
                n = -z;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public final double rotatedComponent(@NotNull ForgeDirection dir, double x, double y, double z) {
        double d;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        boolean $i$f$rotatedComponent = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getReverse()[dir.ordinal()].ordinal()]) {
            case 1: {
                d = x;
                break;
            }
            case 2: {
                d = -x;
                break;
            }
            case 3: {
                d = y;
                break;
            }
            case 4: {
                d = -y;
                break;
            }
            case 5: {
                d = z;
                break;
            }
            case 6: {
                d = -z;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    static {
        int n = 0;
        Rotation[] rotationArray = new Rotation[6];
        while (n < 6) {
            int n2 = n++;
            ForgeDirection forgeDirection = GeometryKt.getForgeDirs()[n2].getOpposite();
            Intrinsics.checkNotNullExpressionValue((Object)forgeDirection, (String)"getOpposite(...)");
            ForgeDirection[] forgeDirectionArray = GeometryKt.getRotations(forgeDirection);
            ForgeDirection forgeDirection2 = GeometryKt.getForgeDirs()[n2];
            Intrinsics.checkNotNullExpressionValue((Object)forgeDirection2, (String)"get(...)");
            rotationArray[n2] = new Rotation(forgeDirectionArray, GeometryKt.getRotations(forgeDirection2));
        }
        rot90 = rotationArray;
        identity = new Rotation(GeometryKt.getForgeDirs(), GeometryKt.getForgeDirs());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmods/octarinecore/client/render/Rotation$Companion;", "", "<init>", "()V", "rot90", "", "Lmods/octarinecore/client/render/Rotation;", "getRot90", "()[Lmods/octarinecore/client/render/Rotation;", "[Lmods/octarinecore/client/render/Rotation;", "identity", "getIdentity", "()Lmods/octarinecore/client/render/Rotation;", "BetterFoliage-LegacyEdition"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rotation[] getRot90() {
            return rot90;
        }

        @NotNull
        public final Rotation getIdentity() {
            return identity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ForgeDirection.values().length];
            try {
                nArray[ForgeDirection.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.SOUTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForgeDirection.NORTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

