#include "/lib/config.glsl"

// MAIN FUNCTION ------------------

#if defined THE_END
    #include "/lib/color_utils_end.glsl"
#elif defined NETHER
    #include "/lib/color_utils_nether.glsl"
#else
    #include "/lib/color_utils.glsl"
#endif

/* Uniforms */

uniform float viewWidth;
uniform float viewHeight;
uniform int frameCounter;
uniform float far;
uniform sampler2D tex;
uniform int isEyeInWater;
uniform float nightVision;
uniform float rainStrength;
uniform float wetness;
uniform float light_mix;
uniform float pixel_size_x;
uniform float pixel_size_y;
uniform sampler2D gaux4;
uniform mat4 gbufferProjectionInverse;
uniform vec3 sunPosition;

#if defined GBUFFER_BLOCK
    uniform float frameTimeCounter;
    uniform vec3 cameraPosition;
    uniform mat4 gbufferModelViewInverse; 
#endif

#if defined DISTANT_HORIZONS
    uniform float dhNearPlane;
#endif

#if defined GBUFFER_ENTITIES
    uniform int entityId;
    uniform vec4 entityColor;
#endif

#if defined SHADOW_CASTING
    uniform sampler2DShadow shadowtex1;
    #if defined COLORED_SHADOW
        uniform sampler2DShadow shadowtex0;
        uniform sampler2D shadowcolor0;
    #endif
#endif

uniform float blindness;

#if MC_VERSION >= 11900
    uniform float darknessFactor;
    uniform float darknessLightFactor;
#endif

#ifdef MATERIAL_GLOSS
     // Don't remove
#endif

#if defined MATERIAL_GLOSS && !defined NETHER
    uniform int worldTime;
    uniform vec3 moonPosition;
    #if defined THE_END
        uniform mat4 gbufferModelView;
    #endif
#endif

/* Ins / Outs */

varying vec2 texcoord;
varying vec4 tint_color;
varying float fog_adj;
varying vec3 direct_light_color;
varying vec3 candle_color;
varying float direct_light_strength;
varying vec3 omni_light;
in float ore_type_f;
in float emitter_type_f;
varying float block_type_f;
varying float exposure;
varying vec4 position;

#if defined GBUFFER_BLOCK
    varying vec3 worldPos;
#endif

#ifdef FOLIAGE_V
    varying float is_foliage;
#endif

#if defined SHADOW_CASTING && !defined NETHER
    varying vec3 shadow_pos;
    varying float shadow_diffuse;
#endif

#if defined MATERIAL_GLOSS && !defined NETHER
    varying vec3 flat_normal;
    varying vec3 sub_position3;
    varying vec3 sub_position3_norm;
    varying vec2 lmcoord_alt;
    varying float gloss_factor;
    varying float gloss_power;
    varying float luma_factor;
    varying float luma_power;
#endif

/* Utility functions */

#include "/lib/luma.glsl"

#if (defined SHADOW_CASTING && !defined NETHER) || defined DISTANT_HORIZONS
    #include "/lib/dither.glsl"
#endif

#if defined SHADOW_CASTING && !defined NETHER
    #include "/lib/shadow_frag.glsl"
#endif

#if defined MATERIAL_GLOSS && !defined NETHER
    #include "/lib/material_gloss_fragment.glsl"
#endif

#if defined GBUFFER_BLOCK
    #include "/lib/end_portal.glsl"
#endif

int ore_type = int(round(ore_type_f));
int emitter_type = int(round(emitter_type_f));
int block_type = int(round(block_type_f));

vec3 computeRealLight(vec3 omni, vec3 directColor, float directStrength, vec3 shadow, vec3 material, vec3 candle) {

    return omni + shadow * directColor * (directStrength + material) * (1.0 - (rainStrength * 0.75)) + candle;
}

void main() {
    vec4 fragpos = gbufferProjectionInverse * (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
    vec3 nfragpos = normalize(fragpos.xyz);
    float sun_influence = dot(nfragpos, sunPosition * 0.01);
    float final_sun_factor = pow(smoothstep(-1.0, 1.0, sun_influence), day_blend_float(1.0, 1.0, 1.75));
    float final_sun_factor2 = pow(smoothstep(-1.0, 1.0, sun_influence), day_blend_float(1.5, 0.0, 10.0));

    
    #if (defined SHADOW_CASTING && !defined NETHER) || defined DISTANT_HORIZONS
        #if AA_TYPE > 0 
            float dither = shifted_dither13(gl_FragCoord.xy);
        #else
            float dither = r_dither(gl_FragCoord.xy);
        #endif
    #endif
    // Avoid render in DH transition
    #ifdef DISTANT_HORIZONS
        float t = far - dhNearPlane;
        float sup = t * TRANSITION_DH_SUP;
        float inf = t * TRANSITION_DH_INF;
        float umbral = (gl_FogFragCoord - (dhNearPlane + inf)) / (far - sup - inf - dhNearPlane);
        if(umbral > dither) {
            discard;
            return;
        }
    #endif
    
    // Toma el color puro del bloque
    #if defined GBUFFER_ENTITIES && BLACK_ENTITY_FIX == 1
        vec4 block_color = texture2D(tex, texcoord);
        if(block_color.a < 0.1 && entityId != 10101) {   // Black entities bug workaround
            discard;
        }
    #else
        vec4 block_color = texture2D(tex, texcoord);
    #endif
    
    vec4 pure_block_color = block_color;
    block_color *= tint_color;
    float block_luma = luma(block_color.rgb);
    
    vec3 final_candle_color = candle_color;

    #ifdef GBUFFER_WEATHER
        block_color.a *= .5;
    #endif

    #if defined GBUFFER_ENTITIES
        // Thunderbolt render
        if(entityId == 10101) {
            block_color.a = 1.0;
        }
    #endif

    #if defined GBUFFER_BLOCK
    if (block_type == 1){
        block_color.rgb = end_portal();
    }
    #endif

    #if defined SHADOW_CASTING && !defined NETHER
        #if defined COLORED_SHADOW
            vec3 shadow_c = get_colored_shadow(shadow_pos, dither);
            shadow_c = mix(shadow_c, vec3(1.0), shadow_diffuse);
        #else
            vec3 shadow_c = get_shadow(shadow_pos, dither);
            shadow_c = mix(shadow_c, vec3(1.0), shadow_diffuse);
        #endif
    #else
        vec3 shadow_c = vec3(abs((light_mix * 2.0) - 1.0));
    #endif

    #if defined GBUFFER_BEACONBEAM
        block_color.rgb *= block_color.rgb * 2 / exposure;
    #elif defined GBUFFER_ENTITY_GLOW
        block_color.rgb =
            clamp(v3_luma(block_color.rgb) * vec3(0.75, 0.75, 1.5), vec3(0.3), vec3(1.0));
    #else
    
        #if defined MATERIAL_GLOSS && !defined NETHER
            float final_gloss_power = gloss_power;
            block_luma *= luma_factor;
            block_luma = pow(block_luma, luma_power);
            vec3 material_gloss_factor = vec3(material_gloss(reflect(sub_position3_norm, flat_normal), lmcoord_alt, final_gloss_power, flat_normal, mix(v3_luma(direct_light_color), direct_light_color, 0.5) * gloss_factor));
                        
            vec3 real_light = computeRealLight(omni_light, direct_light_color, direct_light_strength, shadow_c, material_gloss_factor * block_luma, candle_color);
        #else
            vec3 real_light = computeRealLight(omni_light, direct_light_color, direct_light_strength, shadow_c, vec3(0.0), final_candle_color);
        #endif

        block_color.rgb *= mix(real_light, vec3(1.0), nightVision * 0.125);
        block_color.rgb *= mix(vec3(1.0, 1.0, 1.0), vec3(NV_COLOR_R, NV_COLOR_G, NV_COLOR_B), nightVision);
        
        #if defined GBUFFER_TERRAIN || defined GBUFFER_TEXTURED || defined GBUFFER_ENTITIES
            #include "/lib/emissive_materials.glsl"
        #endif
    #endif
    
    #ifdef GBUFFER_WEATHER
        block_color = saturate_v4(block_color, 0.25);
    #endif

    #if defined GBUFFER_ENTITIES
        if(entityId == 10101) {
        // Thunderbolt render
            block_color = vec4(1.0, 1.0, 1.0, 0.5);
        } else {
            vec3 real_light = computeRealLight(omni_light, direct_light_color, direct_light_strength, shadow_c, vec3(0.0), final_candle_color);
            float entity_poderation = luma(real_light); // Red damage bright ponderation
            block_color.rgb = mix(block_color.rgb, entityColor.rgb, entityColor.a * entity_poderation * 3.0);
        }
    #endif

    #if MC_VERSION < 11300 && defined GBUFFER_TEXTURED
        block_color.rgb *= 1.5;
    #endif

    // block_color = clamp(block_color, vec4(0.0), vec4(vec3(50.0), 1.0));

    #include "/src/finalcolor.glsl"
    #include "/src/writebuffers.glsl"
}