#include "/lib/config.glsl"

/* Color utils */

#ifdef THE_END
    #include "/lib/color_utils_end.glsl"
#elif defined NETHER
    #include "/lib/color_utils_nether.glsl"
#else
    #include "/lib/color_utils.glsl"
#endif

#include "/lib/luma.glsl"

/* Uniforms */

uniform sampler2D tex;
uniform vec3 sunPosition; // View Space
uniform vec3 moonPosition; // View Space

/* Ins / Outs */

varying vec2 texcoord;
varying vec4 tint_color;
varying float sky_luma_correction;
varying vec3 cursed_sky;
varying float current_wetness;

// MAIN FUNCTION ------------------

void main() {
    #if defined THE_END
        vec4 block_color = vec4(ZENITH_DAY_COLOR, 1.0);
        vec3 background_color = ZENITH_DAY_COLOR;
    #elif defined NETHER
        vec4 background_color_full = vec4(mix(fogColor * 0.1, vec3(1.0), 0.04), 1.0);
        vec3 background_color = background_color_full.rgb;
        vec4 block_color = vec4(background_color, 1.0);
    #else
        vec3 sun_direction = sunPosition * 0.01;
        vec3 moon_direction = moonPosition * 0.01;
        
        // Margin for discard
        float frustum_margin = 0.125; // ~120 degrees cull
        bool sun_offscreen = sun_direction.z < frustum_margin;
        bool moon_offscreen = moon_direction.z < frustum_margin;
        
        if (sun_offscreen && moon_offscreen) {
            discard;
        } // Space-Screen sun and moon

        vec4 block_color = texture2D(tex, texcoord) * tint_color;
        
        if (block_color.a < 0.1) {
            discard;
        }
        
        block_color.rgb *= sky_luma_correction * current_wetness;
        #if COLOR_SCHEME == 11
            block_color.rgb *= day_blend_float(1.0, 1.5, sqrt(luma(block_color.rgb) * 0.5));
        #else
            block_color.rgb *= day_blend(block_color.rgb, block_color.rgb, sqrt(block_color.rgb));
        #endif

        block_color.rgb = pow(block_color.rgb, vec3(ASTRO_POWER));
        
        #if COLOR_SCHEME == 12
            block_color.rgb *= cursed_sky;
        #endif
    #endif

    #include "/src/writebuffers.glsl"
}