// LITE shaders 4.6 - Prepare_fragment.glsl
// Sky colors.

#include "/lib/config.glsl"

/* Color utils */

#ifdef THE_END
    #include "/lib/color_utils_end.glsl"
#elif defined NETHER
    #include "/lib/color_utils_nether.glsl"
#else
    #include "/lib/color_utils.glsl"
#endif

/* Uniforms */

uniform mat4 gbufferProjectionInverse;
uniform float pixel_size_x;
uniform float pixel_size_y;
uniform float rainStrength;
uniform float wetness;
uniform vec3 sunPosition;
uniform float eyeAltitude;
uniform float light_mix;
uniform vec4 lightningBoltPosition;
uniform float frameTime;

/* Ins / Outs */

varying vec3 up_vec;
varying vec2 texcoord;
varying vec3 hi_sky_color;
varying vec3 mid_sky_color;
varying vec3 low_sky_color;
varying vec3 pure_hi_sky_color;
varying vec3 pure_mid_sky_color;
varying vec3 pure_low_sky_color;

/* Utility functions */

#include "/lib/dither.glsl"


// MAIN FUNCTION ------------------

void main() {
    #if defined THE_END || defined NETHER
        vec3 block_color = ZENITH_DAY_COLOR;
    #else
        vec3 block_color;

        #if AA_TYPE > 0
            float dither = shifted_dither13(gl_FragCoord.xy);
        #else
            float dither = dither13(gl_FragCoord.xy);
        #endif

        dither = (dither - .5) * 0.03125;

        #if ((COLOR_SCHEME == 8 && SIMPLE_SKY == 0) || COLOR_SCHEME == 12) && !defined UNKNOWN_DIM // LITE Realistic Plus            
            vec4 fragpos = gbufferProjectionInverse * (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
            vec3 nfragpos = normalize(fragpos.xyz);
            float n_u = clamp(dot(nfragpos, up_vec) + 0.1 + dither, 0.0, 1.0);

            float raw_blend = pow(n_u, 0.5); // Sky height
            float blend_initial = mix(0.0, 1.0, raw_blend);

            float transition1_start = 0.0; // Horizon start
            float transition_mid_point = 0.6; // Mid sky max
            float transition2_end = 1.0; // Mid sky end

            // - COLOR INTERPOLATIONS - //
            
            #include "/src/current_sky_color.glsl"
            current_low_sky_color = xyz_to_rgb(current_low_sky_color);
            current_mid_sky_color = xyz_to_rgb(current_mid_sky_color);
            current_hi_sky_color = xyz_to_rgb(current_hi_sky_color);

            float t1 = smoothstep(transition_mid_point, transition2_end, blend_initial + (final_sun_factor * day_blend_float(0.0, 0.0, 0.1)));
            float t2 = smoothstep(transition1_start, transition_mid_point, blend_initial - day_blend_float(0.05, 0.1, 0.05) - (final_sun_factor * day_blend_float(0.05, 0.05, 0.0)));

            vec3 temp_sky_color = mix(current_mid_sky_color, current_hi_sky_color, t1);
            block_color = mix(current_low_sky_color, temp_sky_color, t2);
        #elif COLOR_SCHEME == 11 // Vanilla
            vec4 fragpos =
                gbufferProjectionInverse *
                (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
            vec3 nfragpos = normalize(fragpos.xyz);
            float n_u = clamp(dot(nfragpos, up_vec) - 0.1 + dither, 0.0, 1.0);
            
            float raw_blend = pow(n_u, 0.22); // Sky height
            float blend_initial = mix(0.0, 1.0, raw_blend);

            float transition1_start = 0.0; // Horizon start
            float transition_mid_point = 0.65; // Mid sky max
            float transition2_end = 1.0; // Mid sky end

            // - COLOR INTERPOLATIONS - //
            
            #include "/src/current_sky_color.glsl"
            current_low_sky_color = xyz_to_rgb(current_low_sky_color);
            current_hi_sky_color = xyz_to_rgb(current_hi_sky_color);

            float t2 = smoothstep(transition1_start, transition_mid_point, blend_initial - 0.2 - (final_sun_factor * day_blend_float(0.05, 0.05, 0.05)));

            block_color = mix(current_low_sky_color, current_hi_sky_color, t2);
        #else // Using legacy color interpolation.
            vec4 fragpos =
                gbufferProjectionInverse *
                (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
            vec3 nfragpos = normalize(fragpos.xyz);
            float n_u = clamp(dot(nfragpos, up_vec) + dither, 0.0, 1.0);
            
            block_color = mix(low_sky_color, hi_sky_color, smoothstep(0.0, 1.0, pow(n_u, 0.333)));
            block_color = xyz_to_rgb(block_color);
        #endif
    #endif
    
    #include "/src/writebuffers.glsl"
}