#include "/lib/config.glsl"
#include "/lib/luma.glsl"

/* Color utils */

#ifdef THE_END
    #include "/lib/color_utils_end.glsl"
#elif defined NETHER
    #include "/lib/color_utils_nether.glsl"
#else
    #include "/lib/color_utils.glsl"
#endif

/* Uniforms */

uniform sampler2D gaux4;
uniform float pixel_size_x;
uniform float pixel_size_y;

#if COLOR_SCHEME == 8
    uniform vec3 sunPosition;
#endif

#if MC_VERSION < 11604
    uniform mat4 gbufferProjectionInverse;
    uniform float viewWidth;
    uniform float viewHeight;
    uniform float rainStrength;
    uniform float wetness;
    uniform vec4 lightningBoltPosition;
#endif

/* Ins / Outs */

#if MC_VERSION < 11604
    varying vec3 up_vec;
    varying vec3 hi_sky_color;
    varying vec3 mid_sky_color;
    varying vec3 low_sky_color;
    varying vec3 pure_hi_sky_color;
    varying vec3 pure_mid_sky_color;
    varying vec3 pure_low_sky_color;
#endif

varying vec4 star_data;

/* Utility functions */

#if MC_VERSION < 11604
    #include "/lib/dither.glsl"
#endif

// MAIN FUNCTION ------------------

void main() {
    float vanilla_mul;
    #if defined THE_END
        vec4 background_color = vec4(ZENITH_DAY_COLOR, 1.0);
        vec4 block_color = vec4(0.0, 0.0, 0.0, 1.0);
        vanilla_mul = 1.0;
    #elif defined NETHER  // Unused
        vec4 background_color = vec4(mix(fogColor * 0.1, vec3(1.0), 0.04), 1.0);
        vec4 block_color = vec4(mix(fogColor * 0.1, vec3(1.0), 0.04), 1.0);
        vanilla_mul = 1.0;
    #else
        #if MC_VERSION < 11604
            #if AA_TYPE > 0
                float dither = shifted_dither13(gl_FragCoord.xy);
            #else
                float dither = dither13(gl_FragCoord.xy);
            #endif

            dither = (dither - .5) * 0.03125;
            
            #if ((COLOR_SCHEME == 8 && SIMPLE_SKY == 0) || COLOR_SCHEME == 12) && !defined UNKNOWN_DIM // LITE Realistic Plus
                vec4 fragpos = gbufferProjectionInverse * (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
                vec3 nfragpos = normalize(fragpos.xyz);
                float n_u = clamp(dot(nfragpos, up_vec) + 0.05 + dither, 0.0, 1.0);

                float raw_blend = pow(n_u, 0.5); // Sky height
                float blend_initial = mix(0.0, 1.0, raw_blend);

                float transition1_start = 0.0; // Horizon start
                float transition_mid_point = 0.6; // Mid sky max
                float transition2_end = 1.0; // Mid sky end

                // - COLOR INTERPOLATIONS - //
                
                #include "/src/current_sky_color.glsl"
                current_low_sky_color = xyz_to_rgb(current_low_sky_color);
                current_mid_sky_color = xyz_to_rgb(current_mid_sky_color);
                current_hi_sky_color = xyz_to_rgb(current_hi_sky_color);

                float t1 = smoothstep(transition_mid_point, transition2_end, blend_initial);
                float t2 = smoothstep(transition1_start, transition_mid_point, blend_initial - 0.04 - (final_sun_factor * day_blend_float(0.066, 0.05, 0.0)));

                vec3 temp_sky_color = mix(current_mid_sky_color, current_hi_sky_color, t1);
                vec4 background_color = vec4(mix(current_low_sky_color, temp_sky_color, t2), 1.0);
            #else // Others
                vec4 fragpos =
                    gbufferProjectionInverse *
                    (vec4(gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
                vec3 nfragpos = normalize(fragpos.xyz);
                float n_u = clamp(dot(nfragpos, up_vec) + dither, 0.0, 1.0);
                vec4 background_color = vec4(mix(low_sky_color, hi_sky_color, smoothstep(0.0, 1.0, pow(n_u, 0.333))), 1.0);
                background_color.rgb = xyz_to_rgb(background_color.rgb);
            #endif
        #else
            // Toma el color puro del bloque
            vec4 background_color = texture2DLod(gaux4, gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), 0);
        #endif

        vec4 block_color = star_data;
        #if COLOR_SCHEME == 11// LITE Vanilla
            vanilla_mul = 1.2;
        #else
            vanilla_mul = 1.0;
        #endif

        block_color = mix(background_color, block_color * vanilla_mul, block_color);

        #if MC_VERSION >= 11604
            block_color.a = star_data.a;
        #endif
    #endif

    // DEBUG
    // block_color.rgba = vec4(0.7, 0.0, 0.5, star_data.a);

    // -- BUGGED SKY WORKAROUND -- //
    vec3 sat_skyColor = saturate(skyColor, 5.0);
    float min_color = min(min(sat_skyColor.r, sat_skyColor.g), sat_skyColor.b);
    float max_color = max(max(sat_skyColor.r, sat_skyColor.g), sat_skyColor.b);
    float saturation = (max_color - min_color) / (max_color + 0.0001);
    float lum = max(sat_skyColor.r, max(sat_skyColor.g, sat_skyColor.b));

    float lum_smooth = 1.0 - smoothstep(0.0, 0.25, lum);
    float smooth_transition = smoothstep(-0.1, -0.0, saturation);
    float has_saturation = smooth_transition * lum_smooth; 
    // -- BUGGED SKY WORKAROUND -- //

    #if MC_VERSION >= 12104
        block_color = mix(
            vec4(texture2DLod(gaux4, gl_FragCoord.xy * vec2(pixel_size_x, pixel_size_y), 0.0).rgb, clamp(star_data.a, 0.0, 1.0)),
            block_color = mix(background_color, block_color * vanilla_mul, block_color),
            vec4(has_saturation)
        );
        block_color.a *= day_blend_float(0.33, 0.0, 1.0);
    #endif


    
    #include "/src/writebuffers.glsl"
}
