// LITE shaders 4.5 - post.glsl //#include "/lib/post.glsl"
// Sharpening filter.

// Unsharp Masking Principles - https://thebookofshaders.com/
// Adapted.

vec3 sharpen(sampler2D image, vec3 color, vec2 coords) {
    float force = SHARP_FORCE;
    float blur_radius_px = 1.0;
    float contrast_sample_scale = 1.0;
    float threshold = 0.0;

    vec3 blurred_color_sum = vec3(0.0);
    blurred_color_sum += color;

    blurred_color_sum += texture2DLod(image, coords + vec2( blur_radius_px * pixel_size_x, 0.0), 0.0).rgb;
    blurred_color_sum += texture2DLod(image, coords + vec2(-blur_radius_px * pixel_size_x, 0.0), 0.0).rgb;
    blurred_color_sum += texture2DLod(image, coords + vec2(0.0,  blur_radius_px * pixel_size_y), 0.0).rgb;
    blurred_color_sum += texture2DLod(image, coords + vec2(0.0, -blur_radius_px * pixel_size_y), 0.0).rgb;

    vec3 blurred_color = blurred_color_sum / 5.0;

    vec3 high_pass_details = color - blurred_color;
    vec3 sharpened_color = color + high_pass_details * force;

    // Samples
    vec3 left_c     = texture2DLod(image, coords + vec2(-contrast_sample_scale * pixel_size_x, 0.0), 0.0).rgb;
    vec3 right_c    = texture2DLod(image, coords + vec2( contrast_sample_scale * pixel_size_x, 0.0), 0.0).rgb;
    vec3 top_c      = texture2DLod(image, coords + vec2(0.0, -contrast_sample_scale * pixel_size_y), 0.0).rgb;
    vec3 bottom_c   = texture2DLod(image, coords + vec2(0.0,  contrast_sample_scale * pixel_size_y), 0.0).rgb;

    float brightness = luma(color);
    float contrast = max(
        max(length(color - left_c), length(color - right_c)),
        max(length(color - top_c),  length(color - bottom_c))
    );

    // Adaptative contrast
    float haloFade = clamp(1.0 - contrast, 0.0, 1.0);
    float brightnessFactor = clamp(1.0 - brightness, 0.0, 1.0);
    float thresholdMix = smoothstep(0.0, threshold, contrast);

    float finalMix = brightnessFactor * haloFade * thresholdMix;

    return mix(color, sharpened_color, finalMix);
}

vec3 edge_detect(sampler2D image, vec3 color, vec2 coords) {
    vec3 sum = -texture2DLod(image, coords + vec2(-pixel_size_x, -pixel_size_y), 0.0).rgb;
    sum -= texture2DLod(image, coords + vec2(pixel_size_x, -pixel_size_y), 0.0).rgb;
    sum += 4.0 * color;
    sum -= texture2DLod(image, coords + vec2(-pixel_size_x, pixel_size_y), 0.0).rgb;
    sum -= texture2DLod(image, coords + vec2(pixel_size_x, pixel_size_y), 0.0).rgb;

    return vec3(length(sum)) * 0.5773502691896258;
}