#if !defined THE_END && !defined NETHER

    // Fog intensity calculation
    float fog_density_coeff = day_blend_float_lgcy(
        FOG_SUNSET,
        FOG_DAY,
        FOG_NIGHT
    ) * FOG_ADJUST;

    float fog_intensity_coeff = max(eye_bright_smooth.y * 0.004166666666666667, visible_sky);

    #ifdef DISTANT_HORIZONS
        #if COLOR_SCHEME == 12
        fog_adj = pow(
            clamp(gl_FogFragCoord / dhRenderDistance, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff * 0.1, 0.5, wetness)
        );
        #elif COLOR_SCHEME == 11
        fog_adj = pow(
            clamp(gl_FogFragCoord / dhRenderDistance, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff * 0.3, 0.5, wetness)
        );
        #else
        fog_adj = pow(
            clamp(gl_FogFragCoord / dhRenderDistance, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff, 0.5, wetness)
        );
        #endif
    #else
        #if COLOR_SCHEME == 12
        fog_adj = pow(
            clamp(gl_FogFragCoord / far, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff * 0.1, 0.5, wetness)
        );
        #elif COLOR_SCHEME == 11
        fog_adj = pow(
            clamp(gl_FogFragCoord / far, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff, 0.5, wetness)
        );
        #else
        fog_adj = pow(
            clamp(gl_FogFragCoord / far, 0.0, 1.0) * fog_intensity_coeff,
            mix(fog_density_coeff, 0.5, wetness)
        );
        #endif
    #endif

#else
    #if defined NETHER
        #if NETHER_FOG_DISTANCE == 1
            float sight = NETHER_SIGHT;
        #else
        #if defined DISTANT_HORIZONS
            float sight = dhRenderDistance;
        #else
            float sight = NETHER_SIGHT;
        #endif
        #endif
    #else
        #if defined DISTANT_HORIZONS
            float sight = dhRenderDistance;
        #else
            float sight = far;
        #endif
    #endif
    fog_adj = sqrt(clamp(gl_FogFragCoord / sight, 0.0, 1.0));
#endif
