package me.illia.robotmod;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.actions.CustomAction;
import me.illia.robotmod.attachment.TeleportPoint;
import me.illia.robotmod.attachment.TeleportPointAttachedData;
import me.illia.robotmod.registry.ModRegistries;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5603;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
//? if >= 1.21.5 {
import net.minecraft.client.data.*;
import net.minecraft.item.*;
import net.minecraft.registry.*;
import org.apache.commons.io.function.IOQuadFunction;
import java.io.IOException;
import java.util.*;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Util {
	public static final Codec<TeleportPoint> TELEPORT_POINT_C = RecordCodecBuilder.create(inst -> inst.group(
		Codec.STRING.fieldOf("name").forGetter(TeleportPoint::name),
		class_2338.field_25064.fieldOf("pos").forGetter(TeleportPoint::pos),
		class_1937.field_25178.fieldOf("world").forGetter(TeleportPoint::world)
	).apply(inst, TeleportPoint::new));

	public static final Codec<TeleportPointAttachedData> TELEPORT_POINTS_C = RecordCodecBuilder.create(inst -> inst.group(
		TELEPORT_POINT_C.listOf().fieldOf("points").forGetter(TeleportPointAttachedData::points)
	).apply(inst, TeleportPointAttachedData::new));

	public static final class_9139<ByteBuf, TeleportPointAttachedData> TELEPORT_POINTS_PC = class_9135.method_56368(TELEPORT_POINTS_C);

	public static class_2960 id(String name) {
		return class_2960.method_60655(Robotmod.MODID, name);
	}

	public static<T> class_5321<class_2378<T>> key(String id) {
		return class_5321.method_29180(id(id));
	}

	public static <T extends class_1297> class_1299<T> entity(class_2960 id, class_1299.class_1300<T> type) {
		class_5321<class_1299<?>> key = class_5321.method_29179(class_7924.field_41266, id);

		return class_2378.method_39197(
			class_7923.field_41177,
			key,
			type.method_5905(key)
		);
	}

	public static class_1792 item(class_2960 id, Function<class_1792.class_1793, class_1792> func, class_1792.class_1793 settings) {
		class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, id);

		return class_2378.method_39197(
			class_7923.field_41178,
			key,
			func.apply(settings.method_63686(key))
		);
	}

	public static <T extends class_1703> class_3917<T> screenHandler(class_2960 id, class_3917.class_3918<T> factory) {
		class_5321<class_3917<?>> key = class_5321.method_29179(class_7924.field_41207, id);
		return class_2378.method_39197(
			class_7923.field_41187,
			key,
			new class_3917<>(factory, class_7699.method_45397())
		);
	}

	public static <T extends class_1703> class_3917<T> screenHandler(class_2960 id, class_3917.class_3918<T> factory, class_7699 featureSet) {
		class_5321<class_3917<?>> key = class_5321.method_29179(class_7924.field_41207, id);
		return class_2378.method_39197(
			class_7923.field_41187,
			key,
			new class_3917<>(factory, featureSet)
		);
	}

	public static <T extends class_1703, D> ExtendedScreenHandlerType<T, D> extendedScreenHandler(class_2960 id, ExtendedScreenHandlerType.ExtendedFactory<T, D> factory, class_9139<ByteBuf, D> codec) {
		class_5321<class_3917<?>> key = class_5321.method_29179(class_7924.field_41207, id);
		return class_2378.method_39197(
			class_7923.field_41187,
			key,
			new ExtendedScreenHandlerType<>(factory, codec)
		);
	}

	//? if <1.21.10 {
	/*public static SpawnEggItem spawnEgg(Identifier id, BiFunction<EntityType<? extends MobEntity>, Item.Settings, Item> func, EntityType<? extends MobEntity> entity, Item.Settings settings) {
		RegistryKey<Item> key = RegistryKey.of(RegistryKeys.ITEM, id);

		return (SpawnEggItem) Registry.register(
			Registries.ITEM,
			key,
			func.apply(entity, settings.registryKey(key))
		);
	}
	*///?} else {
	public static class_1826 spawnEgg(class_2960 id, Function<class_1792.class_1793, class_1792> func, class_1299<? extends class_1308> entity, class_1792.class_1793 settings) {
		class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, id);

		return (class_1826) class_2378.method_39197(
			class_7923.field_41178,
			key,
			func.apply(settings.method_63686(key).method_72499(entity))
		);
	}
	//?}

	public static class_1826 spawnEgg(class_2960 id, IOQuadFunction<class_1299<? extends class_1308>, Integer, Integer, class_1792.class_1793, class_1826> func, class_1299<? extends class_1308> entity, int primaryColor, int secondaryColor, class_1792.class_1793 settings) {
		class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, id);

		try {
			return class_2378.method_39197(
				class_7923.field_41178,
				key,
				func.apply(entity, primaryColor, secondaryColor, settings.method_63686(key))
			);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public static class_2561 str(Action action) {
		// TODO: handle params and stuff
		return str(action.actionType);
	}

	public static class_2561 str(class_2960 actionType) {
		CustomAction action = ModRegistries.ACTION_TYPE.method_63535(actionType);
		return Util.t(action.translation());
	}

	public static class_5250 t(String key) {
		return class_2561.method_43471(key);
	}

	public static class_5250 t(String key, Object... args) {
		return class_2561.method_43469(key, args);
	}

	public static class_2248 block(class_2960 id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
		class_5321<class_2248> blockKey = class_5321.method_29179(class_7924.field_41254, id);
		class_2248 block = blockFactory.apply(settings.method_63500(blockKey));

		class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, id);
		class_1747 item = new class_1747(block, new class_1792.class_1793().method_63686(itemKey).method_63685());
		class_2378.method_39197(class_7923.field_41178, itemKey, item);

		return class_2378.method_39197(class_7923.field_41175, blockKey, block);
	}

	public static class_2248 block(class_2960 id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings, class_1814 rarity) {
		class_5321<class_2248> blockKey = class_5321.method_29179(class_7924.field_41254, id);
		class_2248 block = blockFactory.apply(settings.method_63500(blockKey));

		class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, id);
		class_1747 item = new class_1747(block, new class_1792.class_1793().method_63686(itemKey).method_63685().method_7894(rarity));
		class_2378.method_39197(class_7923.field_41178, itemKey, item);

		return class_2378.method_39197(class_7923.field_41175, blockKey, block);
	}

	public static class_2248 blockWithoutItem(class_2960 id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
		class_5321<class_2248> blockKey = class_5321.method_29179(class_7924.field_41254, id);
		class_2248 block = blockFactory.apply(settings.method_63500(blockKey));
		return class_2378.method_39197(class_7923.field_41175, blockKey, block);
	}

	public static class_1761 itemGroup(class_2960 id, String translationKey, class_1799 icon, class_1792... items) {
		class_5321<class_1761> groupKey = class_5321.method_29179(class_7924.field_44688, id);
		class_1761 group = class_2378.method_39197(class_7923.field_44687, groupKey, FabricItemGroup.builder().method_47320(() -> icon).method_47321(Util.t(translationKey)).method_47324());

		ItemGroupEvents.modifyEntriesEvent(groupKey).register(fabricItemGroupEntries -> {
			fabricItemGroupEntries.method_45423(Arrays.stream(items).map(class_1799::new).collect(Collectors.toSet()));
		});

		return group;
	}

	public static void itemModels(class_4915 gen, class_1792... items) {
		for (class_1792 item : items) {
			gen.method_65442(item, new class_4942(Optional.of(Util.mc("item/generated")), Optional.of("inventory"), class_4945.field_23006));
		}
	}

	public static class_2960 mc(String val) {
		return class_2960.method_60656(val);
	}

	public static class_5603 pivot(float x, float y, float z) {
		//? if >= 1.21.5 {
		return class_5603.method_32090(x, y, z);
		//?} else {
		/*return ModelTransform.pivot(x, y, z);
		*///?}
	}

	public static boolean night(class_1937 world) {
		long timeOfDay = world.method_8532() % 24000L;
		return timeOfDay >= 13000L && timeOfDay <= 23000L;
	}

	public static String key(class_2561 name) {
		if (name.method_10851() instanceof class_2588 ttc) {
			return ttc.method_11022();
		}
		return null;
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, String key, String string) {
		builder.add(key, string);
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, class_2960 type, String string) {
		builder.add(((class_2588)str(type).method_10851()).method_11022(), string);
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, class_1792 key, String string) {
		builder.add(key, string);
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, class_2248 key, String string) {
		builder.add(key, string);
	}

	public static void add(FabricLanguageProvider.TranslationBuilder builder, class_1299<?> key, String string) {
		builder.add(key, string);
	}

	public static boolean nearest(class_1297 entity, int r, Function<class_2680, Boolean> func) {
		return circleFilled(entity.method_24515(), r).stream().map(cPos -> entityWorld(entity).method_8320(cPos)).anyMatch(func::apply);
	}

	public static List<class_2338> circleFilled(class_2338 center, int radius) {
		List<class_2338> list = new ArrayList<>();
		int cx = center.method_10263(), cz = center.method_10260(), cy = center.method_10264();
		int r2 = radius * radius;
		for (int dx = -radius; dx <= radius; dx++) {
			for (int dy = -radius; dy <= radius; dy++) {
				for (int dz = -radius; dz <= radius; dz++) {
					if (dx*dx + dz*dz <= r2) {
						list.add(new class_2338(cx + dx, cy + dy, cz + dz));
					}
				}
			}
		}
		return list;
	}

	public static void actionType(String key, CustomAction action) {
		class_2378.method_10230(ModRegistries.ACTION_TYPE, id(key), action);
	}

	public static void actionType(class_2960 key, CustomAction action) {
		class_2378.method_10230(ModRegistries.ACTION_TYPE, key, action);
	}

	public static void actionTypes(Object... idsAndActions) {
		if (idsAndActions.length % 2 != 0)
			throw new IllegalArgumentException("You must provide pairs of Identifier and CustomAction");

		for (int i = 0; i < idsAndActions.length; i += 2) {
			class_2960 id = (class_2960) idsAndActions[i];
			CustomAction action = (CustomAction) idsAndActions[i + 1];
			class_2378.method_10230(ModRegistries.ACTION_TYPE, id, action);
		}
	}

	public static class_1937 entityWorld(class_1297 entity) {
		//? if <1.21.10 {
		/*return entity.getWorld();
		*///?} else {
		return entity.method_73183();
		//?}
	}

	public static class_243 entityPos(class_1297 entity) {
		//? if <1.21.10 {
		/*return entity.getPos();
		*///?} else {
		return entity.method_73189();
		 //?}
	}

	public static class_3218 serverEntityWorld(class_1297 entity) {
		//? if <1.21.10 {
		/*return (ServerWorld)entity.getWorld();
		 *///?} else {
		return (class_3218)entity.method_73183();
		//?}
	}

	public static class_2561 e() {
		return class_2561.method_43473();
	}

	public static void border(class_332 ctx, int x, int y, int w, int h, int col) {
		//? if <1.21.10 {
		/*ctx.drawBorder(x, y, w, h, col);
		*///? } else {
		ctx.method_73198(x, y, w, h, col);
		//? }
	}
}
