package me.illia.robotmod.actions;

import me.illia.robotmod.Robotmod;
import me.illia.robotmod.Util;
import me.illia.robotmod.entity.RobotEntity;
import me.illia.robotmod.registry.ModRegistries;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ActionRunner {
	public static void run(Action action, RobotEntity robot, int actionI) {
		class_3218 world = (class_3218)Util.entityWorld(robot);
		MinecraftServer server = world.method_8503();
		long time = world.method_8510();

		if (robot.waiting) {
			server.method_27728().method_27859().method_143().method_985("run_action_after_wait_" + actionI, robot.waitEndTick, new ExecuteActionCallback(robot.method_5628(), actionI, world.method_27983()));
		}

		CustomAction customAction = ModRegistries.ACTION_TYPE.method_63535(action.getActionType());

		if (customAction == null) return;

		customAction.params = action.getParams();

		robot.actionI = actionI;

		if (robot.waiting && time >= robot.waitStartTick && time < robot.waitEndTick) {
			robot.waiting = false;
			return;
		}

		customAction.run(robot);
	}

	public static void stopFor(RobotEntity robot, int ticks) {
		long time = Util.entityWorld(robot).method_8510();
		robot.waitStartTick = time;
		robot.waitEndTick = time + ticks;
		robot.waiting = true;
	}
}
